# -*- coding: utf-8 -*-

# edit 2025-08-23 kasi

import sys, re, requests, xbmcaddon, xbmcgui, xbmc, json, os, os
from resources.lib import vutils as utils
from concurrent.futures import ThreadPoolExecutor, as_completed

try:
	from resources.lib.listitem import ListItemInfoTag

	tagger = True
except:
	tagger = False
addon = xbmcaddon.Addon()
allchannels = {}

chanicons = ['1-2-3tv.png', '13thstreet.png', '3sat.png', 'animalplanet.png', 'anixe+.png', 'anixe.png', 'ard.png', 'ardalpha.png', 'ardbr.png', 'arddaserste.png', 'ardhr.png', 'ardmdr.png', 'ardmdrsachsen.png', 'ardmdrsachsenanhalt.png', 'ardmdrth.png', 'ardndr.png', 'ardrbb.png', 'ardswr.png', 'ardwdr.png', 'arte.png', 'atv.png', 'atv2.png', 'automotorsport.png', 'axnblack.png', 'axnwhite.png', 'bergblick.png', 'bibeltv.png', 'bild.png', 'bildtv.png', 'boomerang.png', 'br.png', 'cartoonito.png', 'cartoonnetwork.png', 'comedycentral.png', 'crime+investigation.png', 'curiositychannel.png', 'dazn1.png', 'dazn2.png', 'deluxemusic.png', 'discovery.png', 'disneychannel.png', 'disneyjunior.png', 'disneyplusfilm.png', 'dmax.png', 'e!.png', 'edgesport.png', 'eurosport1.png', 'eurosport2.png', 'fix&foxi.png', 'geotv.png', 'go2travel.png', 'heimatkanal.png', 'hgtv.png', 'history.png', 'hr.png', 'hse.png', 'hse24extra.png', 'hse24trend.png', 'hse24tv.png', 'hseextra.png', 'hsetrend.png', 'iptv.png', 'jukebox.png', 'junior.png', 'juwelo.png', 'juwelotv.png', 'k-tv.png', 'kabel1.png', 'kabel1classics.png', 'kabel1doku.png', 'kika.png', 'kinowelt.png', 'mdr.png', 'motorvision.png', 'mtv.png', 'muenchen.png', 'n24doku.png', 'natgeowild.png', 'nationalgeographic.png', 'ndr.png', 'nickelodeon.png', 'nickjunior.png', 'nicktoons.png', 'nitro.png', 'ntv.png', 'oe24.png', 'one.png', 'orf1.png', 'orf2.png', 'orf3.png', 'orfsport.png', 'orfsportplus.png', 'otva.png', 'pearltv.png', 'phoenix.png', 'pro7.png', 'pro7fun.png', 'pro7maxx.png', 'puls24.png', 'puls4.png', 'regiotv.png', 'ric.png', 'romancetv.png', 'rtl.png', 'rtl2.png', 'rtlcrime.png', 'rtlliving.png', 'rtlpassion.png', 'rtlup.png', 'sachsen1.png', 'sat1.png', 'sat1emotions.png', 'sat1gold.png', 'servustv.png', 'silverline.png', 'sixx.png', 'sky1.png', 'skyatlantic.png', 'skycinemaaction.png', 'skycinemaclassics.png', 'skycinemafamily.png', 'skycinemafun.png', 'skycinemahighlights.png', 'skycinemapremieren+24.png', 'skycinemapremieren.png', 'skycinemaspecial.png', 'skycinemathriller.png', 'skycomedy.png', 'skycrime.png', 'skydocumentaries.png', 'skykrimi.png', 'skynature.png', 'skyone.png', 'skyreplay.png', 'skyselect.png', 'skyselect1.png', 'skyselect2.png', 'skyselect3.png', 'skyselect4.png', 'skyselect5.png', 'skyselect6.png', 'skyselect7.png', 'skyselect8.png', 'skyselect9.png', 'skyshowcase.png', 'sonnenklartv.png', 'spiegelgeschichte.png', 'sport1.png', 'sportdigital.png', 'srf.png', 'superrtl.png', 'swr.png', 'syfy.png', 'tagesschau24.png', 'tele5.png', 'tlc.png', 'toggoplus.png', 'universaltv.png', 'vox.png', 'voxup.png', 'waidwerk.png', 'warnertvcomedy.png', 'warnertvfilm.png', 'warnertvserie.png', 'wdr.png', 'welt.png', 'weltderwunder.png', 'zdf.png', 'zdfinfo.png', 'zdfneo.png', 'zeeone.png']

def resolve_link(link):
	_headers = {"user-agent": "MediaHubMX/2", "accept": "application/json", "content-type": "application/json; charset=utf-8", "content-length": "115", "accept-encoding": "gzip",
				"mediahubmx-signature": utils.getAuthSignature()}
	_data = {"language": "de", "region": "AT", "url": link, "clientVersion": "3.0.2"}
	url = "https://vavoo.to/vto-cluster/mediahubmx-resolve.json"
	return requests.post(url, data=json.dumps(_data), headers=_headers).json()[0]["url"]


def filterout(name):
	name = name.encode().decode("ascii", errors="ignore")
	for r in(("   ", " "), ("  ", " "), ("SPORT1", "SPORT 1"), ("BIBELTV", "BIBEL TV"), ("DIGITALL", "DIGITAL"), ("EINS", "1"), ("ZWEI", "2"), ("DREI", "3"), ("SIEBEN", "7"), ("III", "3"), ("II", "2"), ("BR TV", "BR"), ("ʜᴅ", "")): name = name.replace(*r).strip()
	if "BLACK" in name: return "AXN BLACK"
	elif "AXN" in name or "WHITE" in name: return "AXN WHITE"
	elif "SONY" in name: return "AXN BLACK"
	elif "WARNER" in name or "TNT" in name:
		if "SERIE" in name: return "WARNER TV SERIE"
		elif "FILM" in name: return "WARNER TV FILM"
		elif "COMEDY" in name: return "WARNER TV COMEDY"
	elif all(ele in name for ele in ["1", "2", "3"]): return "1-2-3 TV"
	elif "CENTRAL" in name or "VIVA" in name: return "COMEDY CENTRAL"
	elif "NICK" in name:
		if "EON" in name: return "NICKELODEON"
		elif "TOONS" in name: return "NICKTOONS"
		elif "J" in name: return "NICK JUNIOR"
	elif "ANIXE" in name: return "ANIXE+" if "+" in name else "ANIXE"
	elif "ERSTE" in name and "DAS" in name: return "ARD Das Erste"
	elif "ZDF" in name:
		if "INFO" in name: return "ZDF INFO"
		elif "NEO" in name: return "ZDF NEO"
		else: return "ZDF"
# edit kasi
	elif "FERNSEHEN" in name:
		if "BR" in name or "BAY" in name: return "ARD BR"
		elif "HR" in name: return "ARD HR"
	elif "DISNEY" in name:
		if "CHANNEL" in name: return "DISNEY CHANNEL"
		elif "J" in name: return "DISNEY JUNIOR"
	elif "SPIEGEL" in name or "CURIOSITY" in name:
		return "SPIEGEL GESCHICHTE" if "GESCHICHTE" in name else "CURIOSITY CHANNEL"
	elif "INVESTIGATION" in name or "A&E" in name: return "CRIME + INVESTIGATION"
	elif "WELT" in name: return "WELT DER WUNDER" if "WUNDER" in name else "WELT"
	elif "GEO" in name:
		if "WILD" in name: return "NAT GEO WILD"
		return "NATIONAL GEOGRAPHIC" if "NAT" in name else "GEO TV"
	elif "N-TV" in name or "NTV" in name: return "NTV"
	elif "PLANET" in name: 
		return "ANIMAL PLANET" if "ANIMAL" in name else "PLANET"
	elif "TELE" in name and "5" in name: return "TELE 5"
	elif "VOX" in name:
		if "UP" in name or "+" in name: return "VOX UP"
		else: return "VOX"
	if "ORF" in name:
		if "SPORT" in name: return "ORF SPORT"
		if "3" in name: return "ORF 3"
		if "2" in name: return "ORF 2"
		if "1" in name: return "ORF 1"
		if "I" in name: return "ORF 1"
	elif "RTL" in name:
		if "SPORT" in name or "LUXE" in name: name=name
		elif "CRIME" in name: return "RTL CRIME"
		elif "SUPER" in name: return "SUPER RTL"
		elif "PLUS" in name or "UP" in name: return "RTL UP"
		elif "PASSION" in name: return "RTL PASSION"
		elif "LIVING" in name: return "RTL LIVING"
		elif "2" in name: return "RTL 2"
		elif "TOTALLY" in name: return "TOTALLY TURTLES"
		else: return "RTL"
	elif "KABE" in name:
		if "CLA" in name: return "KABEL 1 CLASSICS"
		return "KABEL 1 DOKU" if "DO" in name else "KABEL 1"
	elif "PRO" in name:
		if "FUN" in name: return "PRO 7 FUN"
		return "PRO 7 MAXX" if "MAXX" in name else "PRO 7"
	elif "EUROSPORT" in name:
		if "1" in name: return "EUROSPORT 1"
		if "2" in name: return "EUROSPORT 2"
	elif "ATV" in name:
		return "ATV 2" if "2" in name else "ATV"
	elif "SAT" in name:
		if "3" in name: return "3 SAT"
		elif "1" in name:
			if "GOLD" in name: return "SAT 1 GOLD"
			if "EMOT" in name: return "SAT 1 EMOTIONS"
			else: return "SAT 1"
	elif "SKY" in name:
		if not any(ele in name for ele in ["BUNDES", "SPORT", "SELECT", "BOX"]):
			if "DO" in name: return "SKY DOCUMENTARIES"
			elif "REPLAY" in name: return "SKY REPLAY"
			elif "CASE" in name: return "SKY SHOWCASE"
			elif "ATLANTIC" in name: return "SKY ATLANTIC"
			elif "ACTION" in name: return "SKY CINEMA ACTION"
			elif "HIGHLIGHT" in name or "BEST" in name: return "SKY CINEMA HIGHLIGHTS"
			elif "COMEDY" in name: return "SKY COMEDY"
			elif "FAMI" in name: return "SKY CINEMA FAMILY"
			elif "CLASS" in name or "NOSTALGIE" in name: return "SKY CINEMA CLASSICS"
			elif "KRIM" in name: return "SKY KRIMI"
			elif "CRIME" in name: return "SKY CRIME"
			elif "NATURE" in name: return "SKY NATURE"
			elif "SHOWS" in name: return "SKY SERIEN & SHOWS"
			elif "SPECIAL" in name: return "SKY CINEMA SPECIAL"
			elif "PREMIE" in name: return "SKY CINEMA PREMIEREN +24" if "24" in name else "SKY CINEMA PREMIEREN"
			elif ("ONE" in name or "1" in name) and not "CINEMA" in name: return "SKY ONE"
	elif "PULS" in name:
		if "24" in name: return "PULS 24"
		elif "4" in name: return "PULS 4"
	elif "DO" in name and "24" in name: return "N24 DOKU"
# TODO
# edit kasi
	elif "MDR" in name:
		# import pydevd
		# pydevd.settrace('localhost', port=12345, stdoutToServer=True, stderrToServer=True)
		if "TH" in name: name = "ARD MDR THUERINGEN"			# ? nicht immer verfügbar
		elif "ANHALT" in name: name = "ARD MDR SACHSEN ANHALT"	# ? nicht immer verfügbar
		elif "SACHSEN" in name: name = "ARD MDR SACHSEN"		# ? nicht immer verfügbar
		else: name = "ARD MDR"
		return name
	
	for keyword in  [("ALLGAU" ,"ALLGAU TV"), ("HEIMA" ,"HEIMATKANAL"), ("ALPHA", "ARD ALPHA"), ("UNIVERSAL" ,"UNIVERSAL TV"), ("SERVUS" ,"SERVUS TV"),
					 ("FOXI", "FIX & FOXI"), ("FOX" ,"SKY REPLAY"), ("STREET" ,"13TH STREET"), ("ZEE" ,"ZEE ONE"), ("DELUX" ,"DELUXE MUSIC"), ("DISCO" ,"DISCOVERY"),
					 ("TAGESSCHAU" ,"TAGESSCHAU 24"), ("VISION" ,"MOTORVISION"), ("AUTO" ,"AUTO MOTOR SPORT"), ("ROMANCE" ,"ROMANCE TV"),
					 ("NDR", "ARD NDR"), ("RBB", "ARD RBB"), ("WDR", "ARD WDR"), ("SWR", "ARD SWR"), ("ALPHA", "ARD ALPHA"),
					 "SIXX", "EURONEWS", "ARTE", "MTV", "ARD","PHOENIX", "KIKA", "TLC", "DMAX", "HISTORY", "SYFY", "NITRO", "JUKEBOX", "KINOWELT", "WAIDWERK"]:
		if isinstance(keyword, tuple):
			if keyword[0] in name: return keyword[1]
		elif keyword in name: return keyword
	name = re.sub(r"(^(DE|AT|CH) ?(:|\|)| (\|\w|(F|Q|U)?HD\+?|(2|4|8)K|(720|1080|2160)p?|AUSTRIA|GERMANY|DEUTSCHLAND|HEVC|H265|RAW|SD|YOU)|(\(|\[).*?(\)|\])| (DE|\.\D)$)", "", name).strip()
	if name == "SR FERNSEHEN" or name == "SR" or "SRF" in name: return "SRF"
	return name


def new_vav_channels(group):
	_headers={"user-agent": "okhttp/4.11.0", "accept": "application/json", "content-type": "application/json; charset=utf-8", "content-length": "1106", "accept-encoding": "gzip", "mediahubmx-signature": utils.getAuthSignature()}
	items = []
	cursor = 0
	while cursor != None:
		_data={"language":"de","region":"AT","catalogId":"iptv","id":"iptv","adult":False,"search":"","sort":"name","filter":{"group":group},"cursor":cursor,"clientVersion":"3.0.2"}
		r = requests.post("https://vavoo.to/mediahubmx-catalog.json", json=_data, headers=_headers).json()
		items += r.get("items")
		cursor = r.get("nextCursor")
	return items

def vav_channels():
	chans = utils.get_cache("vav_channels")
	if chans: return chans
	items = []
	groups = vavoo_groups()
	for a in ThreadPoolExecutor().map(new_vav_channels, groups):
		items += a
	utils.set_cache("vav_channels", items, timeout = 60 * int(addon.getSetting("vav_cache")))
	return items

def get_vav_channels(groups=None):
	vavchannels = {}
	if not groups:
		try: groups = json.loads(addon.getSetting("groups"))
		except: groups = choose()
		if not groups: return {}
	for item in vav_channels():
		if item["group"] not in groups: continue
		name = filterout(item["name"])
		if name not in vavchannels: vavchannels[name] = []
		if item["url"] not in vavchannels[name]:
			vavchannels[name].append(item["url"])
	return vavchannels

def getchannels():
	# if host and mac and utils.addon.getSetting("stalker")== "true" :
	#	 get_stalker_channels()
	vav_channels = get_vav_channels()
	for k, v in vav_channels.items():
		if k not in allchannels: allchannels[k] = []
		for n in v: allchannels[k].append(n)
	return allchannels


def vavoo_groups():
	groups=[]
	for c in requests.get("https://www2.vavoo.to/live2/index?output=json").json():
		if c["group"] not in groups: groups.append(c["group"])
	return sorted(groups)

def choose():
	groups = vavoo_groups()
	try: oldgroups = json.loads(addon.getSetting("groups"))
	except: oldgroups = False
	preselect = []
	if oldgroups:
		for oldgroup in oldgroups:
			preselect.append(groups.index(oldgroup))
	indicies = utils.selectDialog(groups, "Choose VAVOO Groups", True, preselect)
	group = []
	if indicies:
		for i in indicies: group.append(groups[i])
		addon.setSetting("groups", json.dumps(group))
		return group


def handle_wait(kanal):
	progress = xbmcgui.DialogProgress()
	create = progress.create("Abbrechen zur manuellen Auswahl", "STARTE  : %s" % kanal)
	time_to_wait = int(utils.addon.getSetting("count")) + 1
	for secs in range(1, time_to_wait):
		secs_left = time_to_wait - secs
		if utils.PY2:
			progress.update(int(secs / time_to_wait * 100), "STARTE  : %s" % kanal, "Starte Stream in  : %s" % secs_left)
		else:
			progress.update(int(secs / time_to_wait * 100), "STARTE  : %s\nStarte Stream in  : %s" % (kanal, secs_left))
		xbmc.Monitor().waitForAbort(1)
		if (progress.iscanceled()):
			progress.close()
			return False
	progress.close()
	return True

#TODO
def livePlay(name, type=None, group=None):
	m, i, title = getchannels()[name], 0, None
	if len(m) > 1:
		if utils.addon.getSetting("auto") == "0":
			# Autoplay - rotieren bei der Stream Auswahl
			# ist wichtig wenn z.B. der erste gelistete Stream nicht funzt
			if utils.addon.getSetting("idn") == name:
				i = int(utils.addon.getSetting("num")) + 1
				if i == len(m): i = 0
			utils.addon.setSetting("idn", name)
			utils.addon.setSetting("num", str(i))
			title = "%s (%s/%s)" % (name, i + 1, len(m))  # wird verwendet für infoLabels
		elif utils.addon.getSetting("auto") == "1":
			if not handle_wait(name):  # Dialog aufrufen
				cap = []
				for i, n in enumerate(m, 1):
					cap.append("STREAM %s" % i)
				i = utils.selectDialog(cap)
				if i < 0: return
			title = "%s (%s/%s)" % (name, i + 1, len(m))  # wird verwendet für infoLabels
		else:
			cap = []
			for i, n in enumerate(m, 1): cap.append("STREAM %s" % i)
			i = utils.selectDialog(cap)
			if i < 0: return
			title = "%s (%s/%s)" % (name, i + 1, len(m))  # wird verwendet für infoLabels
	n = m[i]
	o = xbmcgui.ListItem(name)
	url = resolve_link(n)  # if utils.addon.getSetting("hls") == "true" else "%s?n=1&b=5&vavoo_auth=%s|User-Agent=VAVOO/2.6" % (n, getAuthSignature())
	o.setPath(url)
	if utils.addon.getSetting("hls") == "true":
		o.setMimeType("application/vnd.apple.mpegurl")
		o.setProperty("inputstreamaddon" if utils.PY2 else "inputstream", "inputstream.adaptive")
		o.setProperty("inputstream.adaptive.manifest_type", "hls")
	elif utils.addon.getSetting("ffmpeg") == "true" and xbmc.getCondVisibility("System.HasAddon(inputstream.ffmpegdirect)"):
		o.setMimeType("application/vnd.apple.mpegurl")
		o.setProperty("inputstream", "inputstream.ffmpegdirect")
		o.setProperty("inputstream.ffmpegdirect.is_realtime_stream", "true")
		o.setProperty("inputstream.ffmpegdirect.stream_mode", "timeshift")
		if utils.addon.getSetting("openmode") != "0":
			o.setProperty("inputstream.ffmpegdirect.open_mode", "ffmpeg" if utils.addon.getSetting("openmode") == "1" else "curl")
		o.setProperty("inputstream.ffmpegdirect.manifest_type", "hls")
	o.setProperty("IsPlayable", "true")
	title = title if title else name
	infoLabels = {"title": title, "plot": "[B]%s[/B] - Stream %s von %s" % (name, i + 1, len(m))}
	if tagger:
		info_tag = ListItemInfoTag(o, 'video')
		info_tag.set_info(infoLabels)
	else:
		o.setInfo("Video", infoLabels)  # so kann man die Stream Auswahl auch sehen (Info)
	utils.set_resolved(o)
	utils.end()


# def makem3u():
#	 m3u = ["#EXTM3U\n"]
#	 for name in getchannels():
#		 m3u.append('#EXTINF:-1 group-title="Standart",%s\nplugin://plugin.video.vavooto/?name=%s\n' % (name.strip(), name.replace("&", "%26").replace("+", "%2b").strip()))
#	 m3uPath = os.path.join(utils.addonprofile, "vavoo.m3u")
#	 with open(m3uPath, "w") as a:
#		 a.writelines(m3u)
#	 dialog = xbmcgui.Dialog()
#	 ok = dialog.ok('VAVOO.TO', 'm3u erstellt in %s' % m3uPath)


# edit kasi
def channels(items=None, type=None, group=None):
	try: lines = json.loads(addon.getSetting("favs"))
	except: lines=[]
	if items: results = json.loads(items)
	elif type == "vavoo": results = get_vav_channels([group])
	#elif type == "stalker": results = get_stalker_channels([group])
	else: results = getchannels()
	for name in results:
		index = len(results[name])
		title = name if addon.getSetting("stream_count") == "false" or index == 1 else "%s  (%s)" % (name, index)
		o = xbmcgui.ListItem(name)
		img = "%s.png" % name.replace(" ", "").lower()
		iconimage = "DefaultTVShows.png"
		if img in chanicons: iconimage = "https://raw.githubusercontent.com/xsupdater/xsupdater/backup/logos/tv/%s" % img
		else: iconimage = "https://raw.githubusercontent.com/xsupdater/xsupdater/backup/logos/tv/iptv.png"
		o.setArt({"icon":iconimage, "thumb":iconimage, "poster": iconimage})
		cm = []
		if not name in lines:
			cm.append(("zu TV Favoriten hinzufügen", "RunPlugin(%s?action=addTvFavorit&name=%s)" % (sys.argv[0], name.replace("&", "%26").replace("+", "%2b"))))
			plot = ""
		else:
			plot = "[COLOR gold]TV Favorit[/COLOR]" #% name
			cm.append(("von TV Favoriten entfernen", "RunPlugin(%s?action=delTvFavorit&name=%s)" % (sys.argv[0], name.replace("&", "%26").replace("+", "%2b"))))
		cm.append(("Einstellungen", "RunPlugin(%s?action=settings)" % sys.argv[0]))
		# cm.append(("m3u erstellen", "RunPlugin(%s?action=makem3u)" % sys.argv[0]))
		o.addContextMenuItems(cm)
		infoLabels={"title": title, "plot": plot}
		if tagger:
			info_tag = ListItemInfoTag(o, 'video')
			info_tag.set_info(infoLabels)
		else: o.setInfo("Video", infoLabels)
		o.setProperty("IsPlayable", "true")
		param = {"name":name, "type": type, "group": group} if type else {"name":name}
		utils.add(param, o)
	utils.sort_method()
	utils.end()


def favchannels():
	try:
		lines = json.loads(utils.addon.getSetting("favs"))
	except:
		return
	for name in getchannels():
		if not name in lines: continue
		o = xbmcgui.ListItem(name)
		img = "%s.png" % name.replace(" ", "").lower()
		iconimage = "DefaultTVShows.png"
		if img in chanicons: iconimage = "https://raw.githubusercontent.com/xsupdater/xsupdater/backup/logos/tv/%s" % img
		else: iconimage = "https://raw.githubusercontent.com/xsupdater/xsupdater/backup/logos/tv/iptv.png"
		o.setArt({"icon": iconimage, "thumb": iconimage, "poster": iconimage})
		cm = []
		cm.append(("von TV Favoriten entfernen", "RunPlugin(%s?action=delTvFavorit&name=%s)" % (sys.argv[0], name.replace("&", "%26").replace("+", "%2b"))))
		cm.append(("Einstellungen", "RunPlugin(%s?action=settings)" % sys.argv[0]))
		o.addContextMenuItems(cm)
		infoLabels = {"title": name, "plot": "[COLOR gold]Liste der eigene Live Favoriten[/COLOR]"}
		if tagger:
			info_tag = ListItemInfoTag(o, 'video')
			info_tag.set_info(infoLabels)
		else:
			o.setInfo("Video", infoLabels)
		o.setProperty("IsPlayable", "true")
		utils.add({"action": "livePlay", "name": name}, o)
	utils.sort_method()
	utils.end()


def change_favorit(name, delete=False):
	try:
		lines = json.loads(utils.addon.getSetting("favs"))
	except:
		lines = []
	if delete:
		lines.remove(name)
	else:
		lines.append(name)
	utils.addon.setSetting("favs", json.dumps(lines))
	if len(lines) == 0:
		xbmc.executebuiltin("Action(ParentDir)")
	else:
		xbmc.executebuiltin("Container.Refresh")


from resources.lib.indexers import navigator

def a_z_tv():
	from collections import defaultdict
	from urllib.parse import quote_plus
	results = getchannels()
	res = defaultdict(dict)
	for key, val in results.items():
		prefix, number = key[:1].upper() if key[:1].isalpha() else "#", key
		res[prefix][number] = val
	res = dict(sorted(res.items()))
	for key, val in res.items():
		navigator.navigator().addDirectoryItem(key, 'channels&items=%s' % quote_plus(json.dumps(val)), 'vavoo.png', 'DefaultTVShows.png')
	utils.end()


def live():
	try:
		lines = json.loads(utils.addon.getSetting("favs"))
	except:
		lines = []
	if len(lines) > 0: navigator.navigator().addDirectoryItem("[B]TV Favoriten[/B]", 'favchannels', 'vavoo.png', 'DefaultRecentlyAddedMovies.png')
	navigator.navigator().addDirectoryItem("[B]Alle Sender[/B]", 'channels', 'vavoo.png', 'DefaultTVShows.png')
	navigator.navigator().addDirectoryItem("[B]Sender von A bis Z[/B]", 'a_z_tv', 'vavoo.png', 'DefaultTVShows.png')
	utils.end(cacheToDisc=False)