# -*- coding: utf-8 -*-
# Python 3

# Always pay attention to the translations in the menu!
# HTML LangzeitCache hinzugefügt
# showValue:     48 Stunden
# showEntries:    6 Stunden
# showEpisodes:   4 Stunden

import json
import base64
import hashlib
import re
from Cryptodome.Cipher import AES
from resources.lib.handler.ParameterHandler import ParameterHandler
from resources.lib.handler.requestHandler import cRequestHandler
from resources.lib.tools import logger, cParser
from resources.lib.gui.guiElement import cGuiElement
from resources.lib.config import cConfig
from resources.lib.gui.gui import cGui

SITE_IDENTIFIER = 'moviedream'
SITE_NAME = 'Moviedream'
SITE_ICON = 'moviedream.png'

# Global search function is thus deactivated!
if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'false':
    SITE_GLOBAL_SEARCH = False
    logger.info('-> [SitePlugin]: globalSearch for %s is deactivated.' % SITE_NAME)

# Domain Abfrage
DOMAIN = cConfig().getSetting('plugin_' + SITE_IDENTIFIER + '.domain', 'moviedream.to') # Domain Auswahl über die xStream Einstellungen möglich
STATUS = cConfig().getSetting('plugin_' + SITE_IDENTIFIER + '_status') # Status Code Abfrage der Domain
ACTIVE = cConfig().getSetting('plugin_' + SITE_IDENTIFIER) # Ob Plugin aktiviert ist oder nicht

URL_MAIN = 'https://' + DOMAIN
URL_KINO = URL_MAIN + '/kino'
URL_SEARCH = URL_MAIN + '/suchergebnisse.php?text=%s&sprache=Deutsch'


SCRAPER_SETTINGS = f'''
            <group id="moviedream" label="30730">
                <setting id="plugin_moviedream" type="boolean" label="30050" help="30411">
                    <level>0</level>
                    <default>True</default>
                    <control type="toggle"/>
                </setting>
                <setting id="global_search_moviedream" type="boolean" label="30052">
                    <level>0</level>
                    <default>True</default>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_moviedream">false</dependency>
                    </dependencies>
                    <control type="toggle"/>
                </setting>
                <setting id="plugin_moviedream_checkDomain" type="boolean" label="30277">
                    <level>3</level>
                    <default>True</default>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_moviedream">false</dependency>
                        <dependency type="visible" operator="!is" setting="plugin_moviedream">false</dependency>
                    </dependencies>
                    <control type="toggle"/>
                </setting>
                <setting id="plugin_moviedream.domain" type="string" label="30278" help="">
                    <level>3</level>
                    <default/>
                    <constraints>
                        <allowempty>true</allowempty>
                    </constraints>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_moviedream">false</dependency>
                        <dependency type="visible" operator="!is" setting="plugin_moviedream">false</dependency>
                    </dependencies>
                    <control type="edit" format="string">
                        <heading>30278</heading>
                    </control>
                </setting>
                <setting id="plugin_moviedream_status" type="string" label="Dummy" help="">
                    <visible>false</visible>
                    <default>true</default>
                    <control type="toggle"/>
                </setting>
            </group>
'''


def evp_bytes_to_key(password, salt, key_len, iv_len):
    """Implementierung von OpenSSL's EVP_BytesToKey"""
    m = []
    i = 0
    while len(b''.join(m)) < (key_len + iv_len):
        md = hashlib.md5()
        data = password + salt
        if i > 0:
            data = m[i - 1] + password + salt
        md.update(data)
        m.append(md.digest())
        i += 1
    ms = b''.join(m)
    return {
        'key': ms[:key_len],
        'iv': ms[key_len:key_len + iv_len]
    }


def decrypt_cryptojs_aes(encrypted_json_str, passphrase):
    """Entschlüsselt eine mit CryptoJS.AES verschlüsselte URL"""
    try:
        # JSON parsen - hier sind ct, iv und s drin!
        encrypted_data = json.loads(encrypted_json_str)

        # Die drei Werte extrahieren und dekodieren
        ct = base64.b64decode(encrypted_data['ct'])
        iv = bytes.fromhex(encrypted_data['iv'])
        salt = bytes.fromhex(encrypted_data['s'])

        # Schlüssel aus Passwort und Salt ableiten
        key_iv = evp_bytes_to_key(passphrase.encode('utf-8'), salt, 32, 16)
        key = key_iv['key']

        # AES-Entschlüsselung durchführen
        cipher = AES.new(key, AES.MODE_CBC, iv)
        decrypted = cipher.decrypt(ct)

        # PKCS7 Padding entfernen
        padding_length = decrypted[-1]
        decrypted = decrypted[:-padding_length]
        decrypted = decrypted.replace(b'\\', b'')

        return decrypted.decode('utf-8')
    except Exception as e:
        logger.info('-> [<Moviedream]: Decryption error: %s' % str(e))
        return None


def load(): # Menu structure of the site plugin
    logger.info('Load %s' % SITE_NAME)
    params = ParameterHandler()
    params.setParam('sUrl', URL_MAIN)
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30500), SITE_IDENTIFIER, 'showEntries'), params)  # New Movies
    params.setParam('sUrl', URL_KINO)
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30554), SITE_IDENTIFIER, 'showEntries'), params)  # Cinema
    params.setParam('Value', 'Filme')
    params.setParam('sType', 'Filme')
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30502), SITE_IDENTIFIER, 'showValue'), params)  # Movies menu
    params.setParam('Value', 'Genre')
    params.setParam('sType', 'Filme')
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30528), SITE_IDENTIFIER, 'showValue'), params)  # Movies Genre
    params.setParam('Value', 'Serien')
    params.setParam('sType', 'Serien')
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30511), SITE_IDENTIFIER, 'showValue'), params)  # Series Menu
    params.setParam('Value', 'Genre')
    params.setParam('sType', 'Serien')
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30529), SITE_IDENTIFIER, 'showValue'), params)  # Series Genre
    cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30520), SITE_IDENTIFIER, 'showSearch'), params)   # Search
    cGui().setEndOfDirectory()


def showValue():
    params = ParameterHandler()
    oRequest = cRequestHandler(URL_MAIN)
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 48  # 48 Stunden
    sHtmlContent = oRequest.request()
    pattern = 'data-submenu="">.*?{0}<span(.*?)tabindex'.format(params.getValue('Value')) # {0} wird ersetzt durch Value, sucht nach Filme und Serien
    isMatch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, pattern)
    sType = params.getValue('sType')
    if not isMatch:
        # Pattern je nach Typ anpassen
        if sType == 'Filme':
            pattern = 'tabindex="0">{0}</a>(.*?)</ul>'.format(params.getValue('Value')) # Sucht nach Genre
        elif sType == 'Serien':
            pattern = 'Serien<span.*?tabindex="0">{0}</a>(.*?)</ul>'.format(params.getValue('Value')) # Sucht nach Genre
        isMatch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, pattern)
    if isMatch:
        isMatch, aResult = cParser.parse(sHtmlContainer, 'href="([^"]+).>([^<]+)')
    if not isMatch:
        cGui().showInfo()
        return

    for sUrl, sName in aResult:
        if not sUrl.startswith('http'):
            if 'genre' in sUrl:
                sUrl = URL_MAIN + sUrl
            else:
                sUrl = URL_MAIN + '/' + sUrl

        try:
            if 'Komödie' in sName:
                sUrl = sUrl.replace('Komödie','Kom%C3%B6die')
        except Exception as e:
            logger.info('-> [<Moviedream]: URL encoding failed: %s' % str(e))

        params.setParam('sUrl', sUrl)
        cGui().addFolder(cGuiElement(sName, SITE_IDENTIFIER, 'showEntries'), params)
    cGui().setEndOfDirectory()


def showEntries(entryUrl=False, sGui=False, sSearchText=False, sSearchPageText = False):
    oGui = sGui if sGui else cGui()
    params = ParameterHandler()
    isTvshow = False
    if not entryUrl: entryUrl = params.getValue('sUrl')
    oRequest = cRequestHandler(entryUrl, ignoreErrors=(sGui is not False))
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 6  # 6 Stunden
    sHtmlContent = oRequest.request()
    pattern = '<a.style.*?text-deco.*?class="linkto".*?href="([^"]+).*?src="([^"]+).*?">([^<]+).*?h4>'  # Pattern für Menüpunkt "Neues"
    isMatch, aResult = cParser.parse(sHtmlContent, pattern)
    if not isMatch:
        pattern = 'class="linkto.*?href="([^"]+).*?src="([^"]+)">(.*?)</div>' # Allgemeiner Pattern (muss immer am Schluss stehen)
        isMatch, aResult = cParser.parse(sHtmlContent, pattern)
        if not isMatch:
            if not sGui: oGui.showInfo()
            return

    total = len(aResult)
    for sUrl, sThumbnail, sName in aResult:
        sUrl = sUrl.replace('../../', '')
        sThumbnail = sThumbnail.replace('../../', '')
        if sSearchText and not cParser.search(sSearchText, sName):
            continue
        if 'serie' in sUrl: # Wenn Serie in URL, dann ist es eine Serie. Logisch, oder?
            isTvshow = True
        else:
            from resources.lib.tmdb import cTMDB # Noch im Test, soll den TMDbHandler ersetzen
            oMetaget = cTMDB()
            if not oMetaget:
                isTvshow = False
            else:
                meta = oMetaget.search_movie_name(sName)
                if meta and 'id' in meta:
                    isTvshow = False
                else:
                    isTvshow = True

        sThumbnail = URL_MAIN + '/' + sThumbnail
        sUrl = URL_MAIN + '/' + sUrl
        oGuiElement = cGuiElement(sName, SITE_IDENTIFIER, 'showSeasons' if isTvshow else 'showHosters')
        oGuiElement.setMediaType('tvshow' if isTvshow else 'movie')
        oGuiElement.setThumbnail(sThumbnail)
        params.setParam('entryUrl', sUrl)
        params.setParam('sThumbnail', sThumbnail)
        oGui.addFolder(oGuiElement, params, isTvshow, total)

    if not sGui and not sSearchText and not sSearchPageText:
        isMatchNextPage, sNextUrl = cParser.parseSingleResult(sHtmlContent, 'class="righter.*?href="([^"]+)')


        # Start Page Function
        isMatchSiteSearch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, 'paginationcenter(.*?)</div>')
        if isMatchSiteSearch:
            isMatch, aResult = cParser.parse(sHtmlContainer, 'pagenumberselected.*?href=".*?>([^<]+).*?righter.*?href="\?p=(\d+).*?seiterr.*?href="\?p=(\d+)')
            if not isMatch:
                isMatch, aResult = cParser.parse(sHtmlContainer, 'pagenumberselected.*?href=".*?>([^<]+).*?righter.*?href="([^"]+).*?seiterr.*?href="([^"]+)')
            if isMatch:
                for sPageActive, sNextPage, sPageLast in aResult:
                    #sPageName = '[I]Seitensuche starten  >>> [/I] Seite ' + str(sPageActive) + ' von ' + str(sPageLast) + ' Seiten  [I]<<<[/I]'
                    sPageName = cConfig().getLocalizedString(30284) + str(sPageActive) + cConfig().getLocalizedString(30285) + str(sPageLast) + cConfig().getLocalizedString(30286)
                    params.setParam('sNextPage', sNextPage)
                    params.setParam('sPageLast', sPageLast)
                    oGui.searchNextPage(sPageName, SITE_IDENTIFIER, 'showSearchPage', params)
        # End Page Function

        if isMatchNextPage:
            if '?' in entryUrl:    # korrigiert entryUrl das sNextUrl immer richtig auf die nächste Seite verweist
                entryUrl = entryUrl.split('?')[0]
            entryUrl = re.sub(r'/\d+$', '/', entryUrl)
            sNextUrl = entryUrl + sNextUrl
            params.setParam('sUrl', sNextUrl)
            oGui.addNextPage(SITE_IDENTIFIER, 'showEntries', params)
        oGui.setView('tvshows' if isTvshow else 'movies')
        oGui.setEndOfDirectory()


def showSeasons():
    params = ParameterHandler()
    # Parameter laden
    sUrl = params.getValue('entryUrl')
    sThumbnail = params.getValue('sThumbnail')
    isDesc = params.getValue('sDesc') # Vorbereitung zum erweiterten auslesen der Seite
    oRequest = cRequestHandler(sUrl)
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 6  # HTML Cache Zeit 6 Stunden
    sHtmlContent = oRequest.request()
    pattern = 'seasonleiste(.*?)</div>'
    isMatch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, pattern)
    if isMatch:
        isMatch, aResult = cParser.parse(sHtmlContainer, 'href="([^"]+).*?seasonbutton.*?>([^<]+)')
    if not isMatch:
        cGui().showInfo()
        return
    total = len(aResult)
    for sUrl, sName in aResult:
        oGuiElement = cGuiElement(str(sName), SITE_IDENTIFIER, 'showEpisodes')
        oGuiElement.setMediaType('season')
        oGuiElement.setThumbnail(sThumbnail)
        if isDesc:
            oGuiElement.setDescription(isDesc)
        params.setParam('entryUrl', sUrl)
        cGui().addFolder(oGuiElement, params, True, total)
    cGui().setView('seasons')
    cGui().setEndOfDirectory()


def showEpisodes():
    params = ParameterHandler()
    # Parameter laden
    entryUrl = params.getValue('entryUrl')
    if entryUrl.startswith('/'):
        entryUrl = URL_MAIN + entryUrl
    sThumbnail = params.getValue('sThumbnail')
    isDesc = params.getValue('sDesc')
    oRequest = cRequestHandler(entryUrl)
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 4  # HTML Cache Zeit 4 Stunden
    sHtmlContent = oRequest.request()
    pattern = 'class="episodenleiste">(.*?)</div></div>'
    isMatch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, pattern)
    if isMatch:
        isMatch, aResult = cParser.parse(sHtmlContainer, 'href="([^"]+).*?id=.*?button.*?">.*?#(\d+)')
    if not isMatch:
        cGui().showInfo()
        return

    total = len(aResult)
    for sUrl, sEpisode in aResult:
        oGuiElement = cGuiElement('Episode ' + str(sEpisode), SITE_IDENTIFIER, 'showHosters')
        oGuiElement.setThumbnail(sThumbnail)
        if isDesc:
            oGuiElement.setDescription(isDesc)
        oGuiElement.setMediaType('episode')
        sUrl = URL_MAIN + sUrl
        params.setParam('entryUrl', sUrl)
        params.setParam('episode', sEpisode)
        cGui().addFolder(oGuiElement, params, False, total)
    cGui().setView('episodes')
    cGui().setEndOfDirectory()


def showHosters():
    hosters = []
    params = ParameterHandler()
    sUrl = params.getValue('entryUrl')
    sHtmlContent = cRequestHandler(sUrl, caching=False).request()

    # Nach verschlüsselten Links suchen
    pattern = "CryptoJSAesJson\.decrypt\('([^']+)',\s*'([^']+)'\)"
    isMatch, aResult = cParser.parse(sHtmlContent, pattern)

    if isMatch:
        sQuality = '1080'
        for encrypted_json, passphrase in aResult:
            # URL entschlüsseln
            decrypted_url = decrypt_cryptojs_aes(encrypted_json, passphrase)
            decrypted_url = decrypted_url.replace('"', '') # In der URL befinden sich noch ""

            if decrypted_url:
                if 'dsvplay' in decrypted_url:
                    continue
                elif decrypted_url.startswith('//'):
                    decrypted_url = 'https:' + decrypted_url

            sName = cParser.urlparse(decrypted_url).split('.')[0].strip()
            if cConfig().isBlockedHoster(sName)[0]: continue  # Hoster aus settings.xml oder deaktivierten Resolver ausschließen
            hoster = {'link': decrypted_url, 'name': sName, 'displayedName': '%s [I][%sp][/I]' % (sName, sQuality), 'quality': sQuality}
            hosters.append(hoster)

    if hosters:
        hosters.append('getHosterUrl')
    return hosters


def getHosterUrl(sUrl=False):
    return [{'streamUrl': sUrl, 'resolved': False}]


def showSearch():
    sSearchText = cGui().showKeyBoard(sHeading=cConfig().getLocalizedString(30281))
    if not sSearchText: return
    _search(False, sSearchText)
    cGui().setEndOfDirectory()


def _search(oGui, sSearchText):
    showEntries(URL_SEARCH % cParser.quotePlus(sSearchText), oGui, sSearchText)


def showSearchPage(entryUrl=False): # Suche für die Page Funktion
    params = ParameterHandler()
    if not entryUrl: entryUrl = params.getValue('sUrl')
    sPageLast = params.getValue('sPageLast') # Anzahl gefundener Seiten
    #sHeading = 'Bitte eine Zahl zwischen 1 und ' + str(sPageLast) + ' wählen.'
    sHeading = cConfig().getLocalizedString(30282) + str(sPageLast)
    sSearchPageText = cGui().showKeyBoard(sHeading=sHeading)
    if not sSearchPageText: return
    if 'genre' in entryUrl:
        sNextSearchPage = entryUrl + sSearchPageText
    else:
        sNextSearchPage = entryUrl + '?p=' + sSearchPageText
    showEntries(sNextSearchPage)
    cGui().setEndOfDirectory()