# -*- coding: utf-8 -*-
# Python 3
# Always pay attention to the translations in the menu!
# HTML LangzeitCache hinzugefügt
# showGenre:    48 Stunden
# showEntries:   6 Stunden

from resources.lib.handler.ParameterHandler import ParameterHandler
from resources.lib.handler.requestHandler import cRequestHandler
from resources.lib.tools import logger, cParser
from resources.lib.gui.guiElement import cGuiElement
from resources.lib.config import cConfig
from resources.lib.gui.gui import cGui

SITE_IDENTIFIER = 'vhskassette'
SITE_NAME = 'VHSKassette'
SITE_ICON = 'vhskassette.png'

# Global search function is thus deactivated!
if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'false':
    SITE_GLOBAL_SEARCH = False
    logger.info('-> [SitePlugin]: globalSearch for %s is deactivated.' % SITE_NAME)

# Domain Abfrage
DOMAIN = cConfig().getSetting('plugin_' + SITE_IDENTIFIER + '.domain', 'vhskassette.usite.pro') # Domain Auswahl über die xStream Einstellungen möglich
STATUS = cConfig().getSetting('plugin_' + SITE_IDENTIFIER + '_status') # Status Code Abfrage der Domain
ACTIVE = cConfig().getSetting('plugin_' + SITE_IDENTIFIER) # Ob Plugin aktiviert ist oder nicht

URL_MAIN = 'https://' + DOMAIN

#URL_MOVIES = URL_MAIN + '/video/vic/alle_filme'
URL_MOVIES = URL_MAIN + '/video/'
URL_SEARCH = URL_MAIN + '/video/shv'

SCRAPER_SETTINGS = f'''
            <group id="vhskassette" label="30729">
                <setting id="plugin_vhskassette" type="boolean" label="30050" help="30411">
                    <level>0</level>
                    <default>False</default>
                    <control type="toggle"/>
                </setting>
                <setting id="global_search_vhskassette" type="boolean" label="30052">
                    <level>0</level>
                    <default>False</default>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_vhskassette">false</dependency>
                    </dependencies>
                    <control type="toggle"/>
                </setting>
                <setting id="plugin_vhskassette_checkDomain" type="boolean" label="30277">
                    <level>3</level>
                    <default>False</default>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_vhskassette">false</dependency>
                        <dependency type="visible" operator="!is" setting="plugin_vhskassette">false</dependency>
                    </dependencies>
                    <control type="toggle"/>
                </setting>
                <setting id="plugin_vhskassette.domain" type="string" label="30278" help="">
                    <level>3</level>
                    <default/>
                    <constraints>
                        <allowempty>true</allowempty>
                    </constraints>
                    <dependencies>
                        <dependency type="enable" operator="!is" setting="plugin_vhskassette">false</dependency>
                        <dependency type="visible" operator="!is" setting="plugin_vhskassette">false</dependency>
                    </dependencies>
                    <control type="edit" format="string">
                        <heading>30278</heading>
                    </control>
                </setting>
                <setting id="plugin_vhskassette_status" type="string" label="Dummy" help="">
                    <visible>false</visible>
                    <default>true</default>
                    <control type="toggle"/>
                </setting>
            </group>
'''


def load(): # Menu structure of the site plugin
    logger.info('Load %s' % SITE_NAME)
    params = ParameterHandler()
    username = cConfig().getSetting('vhskassette.user')    # Username
    password = cConfig().getSetting('vhskassette.pass')    # Password
    if username == '' and password == '':                   # If no username and password were set, close the plugin!
        import xbmcgui
        xbmcgui.Dialog().ok(cConfig().getLocalizedString(30241), cConfig().getLocalizedString(30262))   # Info Dialog!
    else:
        oRequest = cRequestHandler('https://vhskassette.usite.pro/index/sub/')
        oRequest.addHeaderEntry('X-Requested-With', 'XMLHttpRequest')
        oRequest.addHeaderEntry('Referer', URL_MAIN)
        oRequest.addParameters('user', username) #original
        oRequest.addParameters('password', password) #original
        oRequest.addParameters('rem', '1') #original
        oRequest.addParameters('a', '2') #original
        oRequest.addParameters('ajax', '2') #original
        oRequest.addParameters('_tp_', 'xml') #original
        oRequest.request()
        params.setParam('sUrl', URL_MOVIES)
        cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30502), SITE_IDENTIFIER, 'showEntries'), params)  # Movies
        cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30506), SITE_IDENTIFIER, 'showGenre'), params)    # Genre
        params.setParam('Value', 'internal_search')
        cGui().addFolder(cGuiElement(cConfig().getLocalizedString(30520), SITE_IDENTIFIER, 'showSearch'), params)   # Search
        cGui().setEndOfDirectory()


def showGenre():
    params = ParameterHandler()
    entryUrl = params.getValue('sUrl')
    oRequest = cRequestHandler(entryUrl)
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 48  # 48 Stunden
    sHtmlContent = oRequest.request()
    pattern = '<a[^>]class=[^>]catName[^>][^>]href="([^"]+)"[^>]>([^"]+)</a>'
    isMatch, aResult = cParser.parse(sHtmlContent, pattern)
    if not isMatch:
        cGui().showInfo()
        return

    for sUrl, sName in aResult:
        params.setParam('sUrl', URL_MAIN + sUrl)
        cGui().addFolder(cGuiElement(sName, SITE_IDENTIFIER, 'showEntries'), params)
    cGui().setEndOfDirectory()


def showEntries(entryUrl=False, sGui=False, sSearchText=False, sSearchPageText = False):
    oGui = sGui if sGui else cGui()
    params = ParameterHandler()
    if not entryUrl: entryUrl = params.getValue('sUrl')
    oRequest = cRequestHandler(entryUrl, ignoreErrors=(sGui is not False))
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 6  # 6 Stunden
    if sSearchText:
        oRequest.addHeaderEntry('Referer', entryUrl)
        oRequest.addHeaderEntry('Upgrade-Insecure-Requests', '1')
        oRequest.addParameters('query', sSearchText)
        if '+' in sSearchText:
            oRequest.addParameters('c', '70')
        else:
            oRequest.addParameters('c', '')
    sHtmlContent = oRequest.request()
    pattern = '-preview.*?href="([^"]+).*?src="([^"]+).*?alt="([^"]+).*?title=".*?\((....)'  # inklusive sYear
    isMatch, aResult = cParser.parse(sHtmlContent, pattern)
    if not isMatch:
        if not sGui: oGui.showInfo()
        return

    total = len(aResult)
    for sUrl, sThumbnail, sName, sYear in aResult:
        isQuality, sQuality = cParser.parse(sName, 'HD')
        isTvshow = True if 'Serie' in sName or 'serie' in sUrl else False
        if 'Brennen Muss Salem' in sName: # Fix für brennen muss Salem, ein Film der unter Serien läuft
            isTvshow = False
        for t in (('(HD)', ''), ('(OmU/HD)', '')): # Ausblenden der Elemente im sName vorne
            sName = sName.replace(*t)
        sName = sName.replace('&quot;', '')  # Behebt Darstellungsfehler der Webseite in Bezug auf ""
        #sYear aus name - wird nicht mehr benötigt da über regex geholt
        #isYear, sYear = cParser.parse(sName, '(.*?)\((\d*)\)') # Jahr und Name trennen
        #for name, year in sYear:
        #    sName = name
        #    sYear = year
        #    break
        if sSearchText and not cParser().search(sSearchText, sName):
            continue
        if sThumbnail.startswith('/'):
            sThumbnail = URL_MAIN + sThumbnail
        oGuiElement = cGuiElement(sName, SITE_IDENTIFIER, 'showEpisodes' if isTvshow else 'showHosters')
        oGuiElement.setThumbnail(sThumbnail)
        oGuiElement.setMediaType('tvshow' if isTvshow else 'movie')
        if isQuality:
            oGuiElement.setQuality(sQuality)
        oGuiElement.setYear(sYear)
        # Sprache GUI Element English und Originalsprache mit Untertiteln
        if '/english_movies' in sUrl:
            oGuiElement.setLanguage('EN')
        if '/omu_originalsprache' in sUrl:
            oGuiElement.setLanguage('OmU')
        params.setParam('entryUrl', URL_MAIN + sUrl)
        oGui.addFolder(oGuiElement, params, isTvshow, total)
    if not sGui and not sSearchText and not sSearchPageText:
        # Start Page Function
        isMatchSiteSearch, sHtmlContainer = cParser.parseSingleResult(sHtmlContent, """pagesBlockuz(.*?)<hr\s/>""")
        if isMatchSiteSearch:
            isMatch, aResult = cParser.parse(sHtmlContainer, """swchItemA"><span>([\d]+)</span>.*?class="swchItem".*?([\d]+)</span></a><a class="swchItem\sswchItem-next.*?spages[^>][^>]([^']+)""")
            aResult2 = cParser().parse(sHtmlContent, "<span>&raquo;.*?location.href=[^>]([^']+)")   #Pattern für Hauptseite
            if not aResult2[0]:
                aResult2 = cParser().parse(sHtmlContent, "<span>&raquo;.*?location.href = '([^']+)") # Pattern für genre
            if aResult2[0] and aResult2[1][0]:
                for Url in aResult2[1]:
                    sNextPage = URL_MAIN + Url
                    params.setParam('sNextPage', sNextPage)
            if aResult:
                for sPageActive, sPageLast, sNextPageID in aResult:
                    # sPageName = '[I]Seitensuche starten  >>> [/I] Seite ' + str(sPageActive) + ' von ' + str(sPageLast) + ' Seiten  [I]<<<[/I]'
                    sPageName = cConfig().getLocalizedString(30284) + str(sPageActive) + cConfig().getLocalizedString(30285) + str(sPageLast) + cConfig().getLocalizedString(30286)
                    params.setParam('sNextPageID', sNextPageID)
                    params.setParam('sPageLast', sPageLast)
                    oGui.searchNextPage(sPageName, SITE_IDENTIFIER, 'showSearchPage', params)
        # End Page Function
        aResult = cParser().parse(sHtmlContent, "spages[^>][^>]([^']+)[^>][^>];return[^>]false;[^>]><span>&raquo;.*?location.href = '([^']+)") #Nächste Seite einblenden bei Genre
        if not aResult[0]:
            aResult = cParser().parse(sHtmlContent,"spages[^>][^>]([^']+)[^>][^>];return[^>]false[^>][^>]><span>&raquo;.*?location.href=[^>]([^']+)") # Nächste Seite einblenden in der Hauptseite

        if aResult[0] and aResult[1][0]:
            for sNr, Url in aResult[1]:
                params.setParam('sUrl', URL_MAIN + Url + sNr)
                oGui.addNextPage(SITE_IDENTIFIER, 'showEntries', params)

        oGui.setView('tvshows' if 'serie' in sUrl else 'movies')
        oGui.setEndOfDirectory()


def showEpisodes():
    params = ParameterHandler()
    entryUrl = params.getValue('entryUrl')
    sThumbnail = params.getValue('sThumbnail')
    oRequest = cRequestHandler(entryUrl)
    if cConfig().getSetting('global_search_' + SITE_IDENTIFIER) == 'true':
        oRequest.cacheTime = 60 * 60 * 4  # HTML Cache Zeit 4 Stunden
    sHtmlContent = oRequest.request()
    isMatch, sUrl = cParser().parse(sHtmlContent, 'class="link"[^>]href="([^"]+)')
    if isMatch:
        sHtmlContent2 = cRequestHandler(sUrl[0]).request()
        isMatch, sUrl = cParser().parse(sHtmlContent2, 'mozall.*?src="([^"]+)')
        if isMatch:
            if sUrl[0].startswith('/.s'):
                isMatch, sUrl = cParser().parse(sHtmlContent2, 'iframe.src="([^"]+)') #Sonderfall archive.org in Serien zB Gespenstergeschichten
            sUrl = sUrl[0].replace('&playlist=1', '')
            sHtmlContentSeries = cRequestHandler(sUrl, caching=False).request()
            isMatch, aResult = cParser().parse(sHtmlContentSeries,'title":"([^"]+).*?file":"([^"]+)')  # for archive.org
        if not isMatch:
            isMatch, aResult = cParser().parse(sHtmlContent2, 'eTitle.*?">([^<]+).*?src="([^"]+)') #Dailymotion

    if not isMatch:
        cGui().showInfo()
        return

    total = len(aResult)
    for sName, sUrl in aResult:
        if sUrl.startswith('/'):
            sUrl = 'https://archive.org' + sUrl
            sUrl = cParser.urlEncode(sUrl)

        oGuiElement = cGuiElement(sName, SITE_IDENTIFIER, 'showHosters')
        oGuiElement.setThumbnail(sThumbnail)
        oGuiElement.setMediaType('episode')
        params.setParam('entryUrl', sUrl)
        params.setParam('episode', sName)
        cGui().addFolder(oGuiElement, params, False, total)
    cGui().setView('episodes')
    cGui().setEndOfDirectory()


def showHosters():
    #Area under construction, not every link case tested yet - Hep 16-08-2025
    hosters = []
    params = ParameterHandler()
    sUrl = params.getValue('entryUrl')
    if sUrl.endswith('.mp4'): #Betrifft archive.org in Serien
        hoster = {'link': sUrl, 'name': cParser.urlparse(sUrl)}
        hosters.append(hoster)
        if hosters:
            hosters.append('getHosterUrl')
        return hosters
    sHtmlContent = cRequestHandler(sUrl, caching=True).request()
    isMatch, sUrl = cParser().parse(sHtmlContent, 'class="link"[^>]href="([^"]+)')

    #Hier wird die Seite hinter dem Beschreibungslink aufgerufen, wo sich der echte Film und nicht nur der Trailer befindet
    if isMatch:
        sHtmlContent2 = cRequestHandler(sUrl[0]).request()
        #Suchstrings für diverse Hoster
        isMatch, aResult = cParser().parse(sHtmlContent2, 'widget","([^"]+)')

        if not isMatch:
            isMatch, aResult = cParser().parse(sHtmlContent2, '<iframe.src="([^"]+)')

        if not isMatch:
            isMatch, aResult = cParser().parse(sHtmlContent2, 'iframe.allow.*?src="([^"]+)')   # flimmer.rpmvip
        #isMatch, aResult = cParser().parse(sHtmlContent2, '<iframe.id=.*?src="([^"]+)')
        #if 'bowfile' in aResult[0]: #Wenn Hoster bowfile ist, dann in Container nach dem HD File suchen und direkt ohne Resolver abspielen, siehe getHosterUrl
        #    sHtmlContent3 = cRequestHandler(aResult[0]).request()
        #    isMatch, aResult = cParser().parse(sHtmlContent3, 'mp4HD:.?"([^"]+)')

    if not isMatch:
        if 'Dailymotion' in sHtmlContent:
            isMatch, aResult = cParser().parse(sHtmlContent, 'ical.*?href="([^"]+)') #Dailymotion in Serien

    if isMatch:
        for sUrl in aResult:
            if sUrl.startswith('//'):
                sUrl = 'https:' + sUrl
            hoster = {'link': sUrl, 'name': cParser.urlparse(sUrl)}
            hosters.append(hoster)

    if not isMatch:
        pattern = 'vep-title.*?</h1.*?src=.*?http..([\S]+)'
        isMatch, aResult = cParser.parse(sHtmlContent, pattern)
        if isMatch:
            for sUrl in aResult:
                if sUrl.startswith('//'):
                    sUrl = 'https:' + sUrl
            hoster = {'link': sUrl, 'name': cParser.urlparse(sUrl).split('.')[0].strip()}
            hosters.append(hoster)

    if hosters:
        hosters.append('getHosterUrl')
    return hosters


def getHosterUrl(sUrl=False):
    if 'youtube' in sUrl:
        import xbmc
        if not xbmc.getCondVisibility('System.HasAddon(%s)' % 'plugin.video.youtube'):
            xbmc.executebuiltin('InstallAddon(%s)' % 'plugin.video.youtube')

        if '/embed/' in sUrl:
            sUrl = sUrl.split('/embed/')[1]
            sUrl = sUrl.split('?')[0]
            sUrl = 'plugin://plugin.video.youtube/play/?video_id=' + sUrl
            return [{'streamUrl': sUrl, 'resolved': True}]

    if '.mp4' in sUrl: # für archive.org in Serien
        return [{'streamUrl': sUrl, 'resolved': True}]
    else:
        return [{'streamUrl': sUrl, 'resolved': False}]


def showSearch():
    params = ParameterHandler()
    if params.getValue('Value') == 'internal_search':
        sSearchText = cGui().getSearchText(cConfig().getLocalizedString(30287), 'search_history_sites.json')
    else:
        sSearchText = cGui().showKeyBoard(sHeading=cConfig().getLocalizedString(30287))
    if not sSearchText: return
    _search(False, sSearchText)
    cGui().setEndOfDirectory()


def _search(oGui, sSearchText):
    showEntries(URL_SEARCH, oGui, sSearchText)

def showSearchPage(): # Suche für die Page Funktion
    params = ParameterHandler()
    sNextPage = params.getValue('sNextPage') # URL mit nächster Seite
    sPageLast = params.getValue('sPageLast') # Anzahl gefundener Seiten
    #sHeading = 'Bitte eine Zahl zwischen 1 und ' + str(sPageLast) + ' wählen.'
    sHeading = cConfig().getLocalizedString(30282) + str(sPageLast)
    sSearchPageText = cGui().showKeyBoard(sHeading=sHeading)
    if not sSearchPageText: return
    sNextSearchPage = sNextPage.split('*')[0].strip() + '*' + sSearchPageText
    showEntries(sNextSearchPage)
    cGui().setEndOfDirectory()