import re
import sys
import codecs


def decodeSalt(e):
    t = ""
    for c in e:
        t += str(ord(c) - 100)
    return t


def test(e):
    return True if re.search(r'_juicycodes\(', e, re.IGNORECASE) else False


def run(code):
    try:
        symbolMap = ["`", "%", "-", "+", "*", "$", "!", "_", "^", "="]
        code = re.findall(r'_juicycodes\(([^\)]+)', code, re.IGNORECASE)[0]
        code = eval(code)
        ordSalt = decodeSalt(code[-3:])
        jscode = code[:-3]
        x = (len(jscode) + 3) % 4
        jscode = jscode + "==="
        jscode = jscode[:-x]
        jscode = jscode.replace("_", "+").replace("-", "/")
        jscode = codecs.decode(jscode.encode('ascii'), 'base64')
        obfuscated = codecs.decode(jscode.decode('ascii'), 'rot13')

        ordString = ""
        for c in obfuscated:
            ordString += str(symbolMap.index(c))

        splittedOrd = [ordString[i:i + 4] for i in range(0, len(ordString), 4)]

        deobfuscated = ""
        for c in splittedOrd:
            c = int(c) % 1000 - int(ordSalt)
            deobfuscated += chr(c)

        return deobfuscated

    except:
        return None


def main():
    code = r'''<div class="juicycodes-player" id="jc-player"></div>
    <script type="application/javascript">_juicycodes("KiQrJSQkJWArJC1fJSoqJCEkJS0qJC0qKiQtKyEkJSQlJC"+"VeXyQlISEqKiReKl8qJSoqJD0kKyE9KipfXyQrLS0kJV5e"+"JCUrISQtPV8kJV8hKipfKipfJV4qKl8hKiEtXyohJSQqIS"+"UkKiRgISoqXz0qJF8lKipfKyQlXiskLS0qJCVgJSQlIV8k"+"JSorKipfXypfJT0qKl9fJCVfKyQtPSokLT0tJC0kLSQtXi"+"oqXyUlJGAkKiohYCskYCQkKiFgJCQtJCEkLV8kJC0qPSQt"+"LSUkLSotJCslLSQlXiUkJSo9JC1ePSQtKl4kLSs9JC0lLS"+"QlXi0kLSslJCUqKiokPT0kJS09JC0qKyQtLV4kYCQkKiFg"+"XyQtPS0kJV8qJCtgXiQtLSQkJSVfJC0rPSQlYCokJV49JC"+"0lXiRgJF4qIWAhKiElJCpePSQkJSstKj1eJSQtJCokKyUq"+"JC0kXiQlJSsqPSQkJCsrKypeLV4qPSUrKj0kXiQlJF4qXl"+"4rKiReJCQrJD0qPV4kKiEhLSQtXi0kLSskJGArKiohJCUq"+"IV8rJCskISRgYCQqXiQtJCsrKiQlJF4kK2AhKj0tJCpeXl"+"8qJF4qKj1eXipePS0qPSFfKiElLSRgLSEkYGBeJGAlJSQr"+"LV8qXiUkJC0tPSohLV4qX2A9Kj1gKiQtKyUkJV4qJCUqXi"+"QlJSUqPSFfKl9eXiQlPSUqX14kKiFeXiQtXiUkJWBfKiRe"+"PSQlLT0qPS1fKiE9XiQlKyoqJF4rJC0rKipfYCsqIT09Ki"+"ElJSo9ISoqXi0hJGAlJCohPSEkJS1eJC0hJSohKj0qXmBe"+"KiE9JSo9JSQqPS0qKiFeLSQrLSUqPWAlJCsqLSQrLSEqXj"+"1fKj1gKiohKz0qXj0lJC0rJCQtPS0qJF5fJCstISRgJCsq"+"IWAkKiElJCo9Xj0qIS0hKiFeJSQtIS0qPSEqJCVgXio9Kl"+"8kLV5eJCVgISo9PSQqISotJCUhKypfYF8qPSshKiFeISQt"+"YCQqPV9eKj1fXyo9XiUkYCs9KiEkJSohLSEkJS0lKiFeJS"+"ohXi0kLV9eKl4kXyQtIV4kLSQrJCVfKiQlJSEkLV5fJCVg"+"ISQlLT0kJV9fKl5gKyQlYC0kJSs9Kl9gXiohXiQkKyshJC"+"stJSpfYF4qXishJCUqPSpeYF4qIS1eKl9gLSQrLSoqIS0r"+"JCVeKio9Xl8qXi09Kj1eKiQlYF8qIV4lJC1fXyQtKyokJV"+"4hJCUrXypePT0kKyotKj1eLSQlJSQqX14kJCUkLSpeXysq"+"Xl8kKj0rJCo9KyoqPS1fJC1eKyQlKiQqXiUhJC1fJCQtJS"+"0kLSUtJC1gPSpeJCUkKyslJC1eJCQlYCUkLSoqJC0hKiRg"+"YCsqX14kKl4hPSQlPSoqJF49JC1fPSpeXl8kJSolKiEtIS"+"ohLSQqXiReKl89JCQrJCEqPSQrKl9eJSo9JV8kLT1eKj0k"+"LSQrJSoqPV4kKj1fISo9KiokJV4hKj0kKiQlYCskJSFeKj"+"0rXyQrKl4qPSpfJCUtJSpeXiokJV4tJCUtXyQtJSokK2A9"+"JCUrKipePSsqPT09JCUlISQlYCokLV89Kl5fJSQlJF8kLS"+"stKl4tKyo9YCUkK2AlJCskPSo9Kl4kJSshKl4rXypfXl8q"+"PSEhKl89XiohX18kJSolJCsrPSQrYF8qX14kJCtgISpfYC"+"EqJF4qKl9eJSpeKl4kLV5eJCVgXyo9XyEqXj0tJCtgKyQr"+"LS0qKl8hKiRfISoqXz0kJWAhJC1ePSQtJCQkJSolJCUtXi"+"QtPS0kLV9fJCVgPSQtPV8kJV4hJC0qKyoqXyUqXyU9Kipf"+"LSohLSoqIV8lKl8lLSpfYCsqKl8lKiRfISoqXz0kLV4lJC"+"0qJCQrYCUkLV8tJCUtJSQlKiskLV5fKipfLSpfJSEkYCoh"+"JCshJCoqXy0kLT0kJCsqKyQtJCskJSoqKipfLSpfJV4qKl"+"8hJCslJCQlXl8kJStfJCUqJCQtKiokYCQrKiFgKiQtLS0k"+"LSQrKiEkXyoqXyoqJF8hKipfJCQtJT0kJWAhJCUlJCQlKl"+"4kLSVfKipfPSpfJSsqKl9fKiEtJSohJV4qIT0rKiElISo9"+"K18qKl8rKiRfXioqXyQkJSQlJCVeKyQtJV8kJSo9KipfJS"+"pfJSQqKl8tJCVfLSQtPS0kLT1fJC0kPSQtXiQqXyVeJGAk"+"JCohYF4kYCRfKiFgKyQlLSQkJSsrJC0rKiokPSUkLSQrJC"+"1fJCQtKiskLS0tJC0qISQrJSEkJV5fJCUqKyQtXiUkLSoq"+"JC0rKyQtJSEkJV4rJC0rISQlKl8qJD1fJCUtXiQtKl4kLS"+"1fJGAkKiohYF4kLV4rJC09PSQtXyskJSorJCVgISQtLV4k"+"YCRfKiFgKiQrJCEkKyU9Kl4kPSpePV4qXiQkKiE9ISQlPS"+"UqX149KiEqKipfPSokLS1eKl5gXypeX18kYC0lKl9eKyRg"+"Xl4kYF4hKiElJCohJC0qPWArJC1eKyohKioqISo9KiFfLS"+"o9K18kJSErKj0tKipfPSEkYF4lJCUlISQtPSskLV4qKl9g"+"LSQtISsqXmAqKj1eXyQrJCEqPSQrKj0qJCQrJT0kLT0lJG"+"ArJSohXyEqXi0tKj1fJCRgXl8qISsrJCslLSQtKioqXiQr"+"JCU9JCpeJSUkYC0lJGArKyohXiEqXj1fKj09XyQrKiQkJS"+"oqJC0lXyo9PSUkJS0rKiReLSo9Xz0kJT0hKj0rJCohLV8q"+"PSoqKj0lJSQrLS0kLSsqKiReXipfPSsqIV89JCsqKiohXy"+"EqPStfJC1eXiQtX18kKyQkKl5eXyohKioqISokJCU9Xyoh"+"LV4qPV4rKj0rKio9IT0kLSUqJGArKyQrLSokYCQkKiFgKi"+"QtLSokLWAtJCskPSQrJT0qISolKiRePSpeJCsqXz09JCsq"+"XiQtXy0qPSo9Kj09LSo9YC0qX149JCsqKipeJCEqPSolKl"+"9eISQlPT0kJSFeKiElISQrLT0kJWAqJCslLSQtKl8kJSsr"+"Kl89Kio9Kj0qXj0rJCtgKyohISoqISokKiFfXyohJSskYG"+"AqKiEtJCQlK14kYGA9Kl9eISRgK18qPWAqKiFfXiQlLV8k"+"LV8kJCskXio9YD0kKyQtJC0kPSRgJC0qIWAlKl9ePSohKj"+"0qXipeKl5fJSpeJSskYF4rJGBgXyo9LSUkKy0hJCskXyo9"+"PS0kYC0tJC1gKyQlISQqXl9fJCU9PSpfXiQqIS1fKj1gXi"+"o9JSskJStfJGAlKypeYCskYCteJC0hLSQtJSEqISErJC0l"+"XipeISEqIV8hJC0lISpeJSUkKyo9JCUhJSo9YF8kLSQqJC"+"slISpfYCQqPV49JGAlXio9XiQqXj09Kj1fJSpeXyokLV4t"+"JCsrPSQrKl4qXz1eKiRePSQtLT0qPSReKj0hXyRgYCUkKy"+"0qKl89XiRgKyUqPSEqKiEtXio9Kl8qPV8tKiEtISohISUq"+"XiRfJCUrJCpeISQqIV8qJGArPSo9XyEqXio9JCUhISpeKy"+"QqXisrJCVeLSQlKj0kLS1eJC0lPSohLV4kJWArJCUrJCQl"+"LV8kLS0kJGBgXio9PSUqPSUqJGArXyQtKi0qPWArKl89Xi"+"QlXyQqX2BfJCVeISQlK14qXiElJC0lJSQtXiokLT0tKj1g"+"Kyo9ISokJSQqKj1eJSRgLT0qISsrJC0kXipeK14kJSVeKi"+"ElKiQrJCEqPV8tKl49XypeJT0qX2AlJCUrXyo9JF4qXmAr"+"JC09XyQlJCsqISUlKiEhKypfYC0kLSsrKiFfXiQrLSQqIV"+"89Kj1gKyohXz0kKyQlJCUhLSQtJSEqPT1eJCskLSo9Kyoq"+"PWAkKiErLSRgLS0kYF4kJC0tKiQlJV4kLSErKiElKio9YF"+"8kLS0rKiFeJSohXiUkLSQlJC0kJSpePS0kLT0kKiFfJSQt"+"KyskJV9eJCUkKyQrJCokLV8qKiErXipfXiUqKl8kJCteKi"+"okXy0kKyErKipfJCQtPSQkKypeJC0kLSQlKiUqKl8qKl8l"+"XyoqXyUkKyUkJCVeJCQlKz0kJSolJC0qXiRgJF8qIWA9JC"+"0tKiQtJD0qISReKipfXyokX14qKl8lJC0lKyQlYCUkJSUq"+"JCUqLSQtJSQqKl8tKl8lKioqXyQqIV4hKiErLSohJSQqPS"+"slKipfISokXyUqKl8rJCUkLSQlXi0kLSU9JCUqXioqXyEq"+"XyUrKipfXiQlXyUkLT0rJC09JCQtJCEkLV4lKl8lXyRgJF"+"8qIWAqJGAkJSohYCskJS0qJCUrJSQtKyUqJD0qJC0kJCQt"+"XyskLSpeJC0tKyQtKiskKyUlJCVeXiQlKiEkLV4qJC0qJS"+"QtK18kLSUlJCVeKyQtKyskJSotKiQ9XyQlLSQkLSotJC0t"+"KyRgJD0qIWBfJC1eJCQtPS0kLV8hJCUqPSQlYD0kLS0rJG"+"AkJCohYCEqJF4rKl5gKiohLSoqXz1eJC0qXypeLSskLS0l"+"JCU9Xio9PT0kLSQlKiE9JSQlLSokLT0kKl4rLSQtPS0qIS"+"UqJCUhPSohK18qPSUqJC0tXipeXy0kJT0tJCUlJCohPSQq"+"ISorJCVfLSo9JSoqXz0tKl4hJSRgYCokLSEkJC0lKipeYC"+"UkLSVeKiEtLSpeYF8qXiQtJGBgISo9JV8kLSohJCtgXipe"+"YF8qXmAtKj09ISohXj0qPSsrKiFePSQlYC0qPSsqKiEqXi"+"o9LSoqPSEhKj1gISpeX18kYC0qKiErJCpfYCsqXl4qKj1e"+"PSRgJSsqISVfKj0rXiQtPSQkLV8kKl4qPSo9ISEqXz0lKi"+"ReXyohPV4qISpeKl4tXiQrLSsqPS09JCU9ISo9LV8kYF4l"+"JC0lJCohKyoqPV4lJCVgJSQtPSoqIT0hJGBgJSQlKiUqPS"+"slKl4tLSo9JF4kJSokKl4lPSohKi0kYC0rJGAkJCohYD0q"+"PSVfJCtgPSQtXl8qPT0rKl49PSQlJSUkJSoqKj0hPSRgJS"+"EkLSVfKl5gXypeXyEqPSolKl4hXipeJD0kJS0kKj1eISpe"+"JSEqXmAlJCskISQrKyQqIT0hKj0lJSohXl8kKysqKj1fXy"+"QrYF4qXmArKl5gISQtISEkJV4hKl4rLSQlXisqXistJC1e"+"KyRgJSskKyUqKl4lKiohXiskYC0rKiElXiQtK14kLSReJC"+"1eISQrYCsqPSorJGAtISpfYCskYCQrKiFgISQtXj0qPSst"+"KiE9LSQlJSQqPWA9JC0qLSQlPSokLS0qJGAtKio9YCQkJS"+"olKl4lPSQrLT0kLT0tKiEqJSpfYCoqPSteKj0qXipfYF8q"+"ISFeKl4lXipeXl4qXl9fKj1gXyQtJSEqISsrJCUlJCpeXz"+"0kJV8hKl5gJSQlPSUqIS0lKl49XiQtIS0qIV8tJCsqLSQt"+"IV8kJV8lKl4kJCQlYF4qIS09JC0rPSpePV8kYGArKj1eKy"+"o9KyUkKyQtJGBgLSpeISUkKypfKiFfXiQlKz0qISEtJCUq"+"KiQrJCUqPSFfKl9eXyo9KiEkKyUtKiEtPSQtJCokJSRfKj"+"1gLSpfXiskKystKl89KyQtISUqIT0kKl4kJCQtKiQqPSEh"+"Kj1fPSQlJSUqXl4kKl49PSpfPV4qXl8tKiE9PSQtKz0kYC"+"UkJC09LSQlJF8kYC09JCsrKyo9PSUkLWBeJCUtISQrJSsk"+"LV4tJCskJSpeKl4kYC0rJCUlKiQtJF4kKyskJC0tXipeJC"+"EkLSFeJGAlLSQrJCoqPSohKj0qKipeJSQqPSQrKl5fLSo9"+"PSEkLSQlKj0rLSohLV4qISolKiEqXiRgLSokKy1eKj1eJC"+"ohJF4kLSElKl5gJCQtPSUkJSU9JCVeLSpeYCoqPV8kKl9e"+"XiQrLV8qXz0qKj1gISpeXiQkJSEhJCUtJCo9KysqPV8rJG"+"ArPSo9KiokYCs9JC09ISQtIV8kK2ArKl49LSpeKyoqIS1e"+"JCVfJCQrJS0qIV8tKl4tISo9PSEqIV89KiReISpePSEqXi"+"EqKl5fJSpfYD0qPV5eJC0tXyo9XisqX14tKipfXyQrXiEq"+"JF89JCshISoqXyskLT0qJCsqLSQtJF8kJSolKipfJCpfJS"+"QqKl8tJCslISQlXl8kJSsqJCUqPSQtKiUkYCQqKiFgLSQt"+"LV8kLSQhKiEkPSoqXyQqJF8qKipfKiQtJSUkJWArJCUlPS"+"QlKl8kLSUtKipfJCpfJT0qKl9fKiEqXyohXz0qISU9Kj0r"+"PSoqXy0qJF8tKipfXiQlJCskJV49JC0lLSQlKl4qKl8rKl"+"8lISoqXyEkJV9fJC09PSQtPV4kLSQlJC1eKipfJT0kYCQt"+"KiFgJCRgJCUqIWAlJCUtKiQlK18kLSsqKiQ9XiQtJCUkLV"+"8kJC0qXyQtLSokLSo9JCslPSQlXj0kJSokJC1eISQtKi0k"+"LSskJC0lXiQlXiskLSsqJCUqPSokPSskJS09JC0qKyQtLS"+"UkYCReKiFgKyQtXiskLT1fJC1fJCQlKi0kJWBfJC0tXyRg"+"JF4qIWAlJC0kPSo9LT0qISFfKl4lXyQtIS0kYF4lKj09IS"+"okXj0qPSsrKl9gXyohJF4kJSQrKl4qJSQlJF4kLV8lKiFf"+"XyQtKl8qIS0tKl5gKypfXl4qXiUqJC0tPSohKyEkYCslJG"+"BeLSpeXyQkLT0hJCVfLSpeKiUkLT0rJC1gJCpeJD0qXj0h"+"JCVgPSohIV4qXiQ9JGBgXio9KyQqPS09JCVeJSpeIS0qX1"+"49KiE9PSohKiokKyokKj0kKipfYC0kLWBeJC0tXipeJCsq"+"PSQkKj1fLSQtXiQkJS0qJC09JSQlXyUqIS1eJCU9XyohKi"+"QqXmA9JC0qISohKisqISo9Kl9gJCohIV4kYCUrJGArXyQt"+"YF4qJF4qJCVgJCQrKiskJS09KiEkJCQlK14kJT0qKiEkKi"+"RgKyokLV8rKiFeJSohJCUqISEqJCUlLSohXyUkLSo9Kj09"+"XyQtJS0qIV9eJCsqKiohKiQqPSoqJCstKyRgJD0qIWBfKl"+"9ePSQlJC0kLSQhJCtgJCRgLSUkJSQhKl4rLSQtLSQkLSE9"+"KiEhXiohXiEkLV8kJCU9ISQrJCoqPSElJCslJSQrLSsqIS"+"VeJC0hXypeXyUkLSskKj0lJSo9XiskLSErKl4qXiRgXj0k"+"KyReJC0qXiQrJSEkYGAlJCUqKyQtLSEkLT0kJC0hISo9X1"+"8kJV8qKiEkJSohKl4kJT0kJCUhJCRgYF8kKy1fJCVeISo9"+"JSEqPV4lJCskJCQlXl8qJF5fJGAkJSohYC0qPSFfJGBeJS"+"ohJCUqXmA9JGArXiRgLSskKy09JCslKiQrLSEqPSUrKiFf"+"LSQtIT0kLV4rJCUhISQtJCEkKy0rJC0rKio9ISsqPSQtKj"+"0lJSpeISsqPS09JCskXio9PS0qISQkKl4kLSQrLS0kYC0h"+"Kl5gLSpeJV8kJT1eJC0qPSo9LV4qXl4lKl4qKio9IT0kLS"+"srJCVfPSQtJS0qXl4tJCVgPSo9PT0kK2ArKj0hXyQtKy0q"+"ISReJCsrJCQtKi0qIV4lKj1eKyohKz0qXi0lJC0tISohKi"+"okLSQqJCUlKyQtJT0kJSUrJCskJSpeLSEqXiQlKj0hXyRg"+"YC0kLV5eKiEtKio9Xl8kJSUqKl89ISo9K18qPS0hKj1gKi"+"QrKy0qPSslKiEkLSQlXiEkLWBeKl4tLSRgXi0qXiEhJC0t"+"PSo9JSskK2AkJCU9JSQtXl8kJSFfKiEqKiRgLV4kLSUlJC"+"0tLSo9PSEqX2AkJCtgPSpeXyEkKyotJCVgXiQlXysqX2Al"+"KiErXiRgJSsqXiFfJC09KyQlJCQkYGArJC0hKyQtISUqPS"+"0rKl9eJCQlJSEqXl4tJGArXypeJSokJSRfJCUkJSpeJCsk"+"KyslKl49XiQrKiQkJT1eKj09JCo9JS0kKystKj0hISohIS"+"skKy0qJCUrLSRgLS0qPT1fKj0hKiQlKyskLSUtJC1eLSo9"+"Xl4kKyQqJCtgXyohLS0qXiUlKl4qJCQrJCQqISReJCsrIS"+"peJSoqISo9JC1fXyRgLSoqXiE9JGAlISohPSskLV8kKl4r"+"JCohLS0kYCUqKiEkKypeKyEkLSUqJC1eJSoqXyskK14rJG"+"AhLSokXyQqKl8hJC09LSQtXy0kJWAkJCUtXiQtYCokLV5e"+"KipfJCpfJV8kYCorJCshJCoqXyEkLWBeJCVeLSQtKyQkJS"+"skKipfJSpfJV4qKl9eJC1eJSQrYCUkJSUhJC09XyQlXiok"+"LT0rJC0lPSQlKiEkLV4rKipfJCokXz0qKl8rJCUkLSQlXl"+"8kLSUqJCUqXyoqX18qXyUqKipfJCQlXyEkLT0lJC09PSQt"+"JF8kLV4qKl8lJSRgJD0qIWA9JGAkXyohYCUkLSQrJC1fJS"+"QtKiokLS0kJC0qJSQrJSskJV4tJCUqPSQtXiUkLSotJC0r"+"ISQtJSUkJV5fJC0rJCQlKl4qJD0rJCUtXiQtKi0kLS0qJG"+"AkPSohYCUkLV4rJCtgXyQlJS0kLT09JCVeLSQtPSUkLSUq"+"JCUqXyRgJCEqIWArJC0tJSQtLSskLWBeJCUrKipeX14kJS"+"stKj1gPSQtJS0kJSotKl4rJSQrKiEqXiE9Kj09ISQtPSsq"+"Xj0kKj0kKio9LSEkKypfJCsqLSQlXiskJV8rJCsrXyQtYC"+"EqXi0lJC1gPSQlXz0qX2A9JCstJCo9PSQkJS1eJCslJCo9"+"KyoqISslKl5gKio9YD0kYC0tKj0qJCpePSQqJF4kKl9eXi"+"pfYCUkLV89JCUkLSpeIV4qXiEtJCVgXyo9LV8qPSteKl9e"+"KiohISoqIT0rKj0kJSo9JF4kJSoqKj1fISohXyEkJWAhJC"+"tgJCQtISUqPSEhKl5fJSQtPT0qPSQrJCUhISpfYCokYCUr"+"JGAtKio9Kz0qPSFeKiEkXyQtPSokLWBfKj1eKiQlKyEqXl"+"89JC1eXiQrJSEkK2BeJC0lXiohPSokYCtfJCUkJCohXl4q"+"PSpfJC0tLSo9PS0qPSstKj1eXyRgLV4qXisrJC0qJSRgJF"+"4qIWAqKl4hJSohKysqX2AhJCstLSohKiEkJSotKl4qKyQt"+"LSUqPSQkKj0rJSo9ISsqX14qKiErPSQlXiQkYCUlJCUtLS"+"QrJT0qIV4qJCVeJSo9PSsqISo9Kj09XiRgJT0kJSVeJCUr"+"JCohJSEqISUrKiEkPSpeYCskLS1eJCVfJCQtXyUqISQqKl"+"4rISohPS0kLV9fKiReJSpeJSUkKyUkJC0kISpeJSUqIV8r"+"Kj0hKiRgYCUkLSUhKiE9JCpfXioqPSUhJC1gKyQlJD0qIS"+"FfKj1fKiRgKyokYGAtKiFeLSo9JCQkKyUtKl9gXyQlKiQq"+"PSoqKj1gKyo9PS0kYCshJC0kXiQrKj0kKyUkJCtgLSRgKy"+"0qPSsqJCUlISpeXiEqIS1eJCUkJSpeISQqXl89JC0hKyRg"+"KyskKy09KiEqJSo9YD0kJSEtKl5gXypeYF4qXiFfKj0kKy"+"QlYCUkKyshJGArPSQlXysqXishJCU9KyQrJD0qISstKiEq"+"ISo9PV8kLT0kJC0hISohPSQqIV8rJCUrXyo9XyUkLSUtKl"+"89KiQlYC0qPSVeJGArJSo9PV8qIT09JGAtISo9LSEqIT09"+"JCUrKiRgK14kYC1fKiEkISohPV8kJSteKl5gJCQtYF8kLS"+"oqJC0kXiohKyEqISEhKj0kKiokXiskJSVfKl4rJSo9IV8k"+"JV8tKj0rISQlX14kLT0kJGAtKypfPV8qIS1fJCUhXyQlXi"+"UkJV4lKiReKiohJSEkLWAqJC1gJSQtKiEqXmAhKiElKiRg"+"LSEqPSUkKiEqISpeKiEkYCslKl89KypeXyokJWAlKl9eJS"+"peISsqKl8kKiRfKioqXy0kLSVeJCVgJSQlJS0kJSpeJC0l"+"PSoqXz0qXyUqKipfJCRgYCskJSpeJC1eKiQtPSEkKy1fJC"+"0qKiQtXyEkLSUqJCUrXyoqJF4qISpfJCsrJCohLSUqKl9e"+"KiRfJCoqXyUkJSteJCUqPSQlJF8kJWAlJCtgISQtJSQkLT"+"0tKipfJCpfJS0kLT0tJC1fPSQrYCQkJSorJCteJCRgIV4q"+"JF9eKipfJSQlLSskJWBfJC0kXiQtPSokJV4lJC0qJCQtKy"+"QkLV4kKipfJCpfJV8kKyFeKipfXiQlLV4kLSpeJC0lPSQt"+"Ki0kLV9eKipfXypfJSsqKl9fKipeJCQlJF8kJSQlJCUkPS"+"QlJC0kJSQrJCUkLSoqX14qJF89KipfKyQlKiskJSshJCUh"+"LSQlKiUqPSEhJC09JSQrKiUkLSUtJCUqXioqXyUqXyUqKi"+"pfISQtKyokLSo9JC0rJSQlKl8qKl9eKiRfXyoqXyokJSQt"+"JC0qKiQtKyQkLT0rKj0hJSQlXiskKyQrJCUqXyoqXysqXy"+"UlKipfJSohLV8qIT09KipfKiokXyEqKl8kJCUkLSQtKiUk"+"LSsrJC09ISpeKyEkJWAkJC0tKiQlXiUkLSUtJCsqXyoqXy"+"oqXyVfKipfJSo9Xz0kLV9eJCUqXyQlJSQkK2AtJCUtKyQl"+"XyEkJSo9JC09JSoqJCUqPWA9Kj0hKiokXyUqKiQ9Kj0hKy"+"QlYC0kLSshJC1eJSoqJF4qPSEqJCUqJSQtXyokJV4hJCUk"+"KioqXyEqJF8lKipfISQlJSQkJWAtJCUtXyQtYF8kJSErJC"+"1fKyQtKiEkK2ArJC0rKyQlKyQqXmAlJC0qLSQtJSUkLSot"+"JC1fKyoqXyUqXyVfKipfLSoqXiUqISUhKiElJCohJT0qIS"+"VfKiElJCohJS0qKl8hKiRfXyoqXyUkJSUrJCVgXiQlLT0k"+"LWA9JCUhJCQtXyokLSoqJCtgJSQtK18kJSstKj0tKiQtJC"+"skJWAtJCUtXyQlXj0kLT09JCsqISoqXz0qXyUlKiFeKyoh"+"ISEkK14kKiRfKioqXz0kJWAtJCUlJCQtKi0kK2AhJC09JS"+"QtPSEkJSotJCsrXyQtPV4qKl89Kl8lXioqXy0qPSsqJC1f"+"JSQtKiEkLS1fJC0qPSQrJV4kJV49JCUqKiQtXi0qJD1fJC"+"0kJSQtX18kLSolKipfKiokXyoqKl8qJCVgISQlJSUkLSpf"+"JCtgXyQtPS0kLSUqJCVeXyQtKyUkLWAtKipfKypfJSQqKl"+"8kJCVfJSQtPSskLT1eJC0kISQtXiUqXyUhJGAkKyohYCsk"+"YCQ9KiFgKiQtJCQkLV8tJC0qJSQtLSokLSo9JCslXiQlXi"+"skJSoqJC1eISokPV4kLSQrJC1fXiQtKisqKl8qJCteKypf"+"LSQkJT0qJCstLSQtJCUkLSUqJCVgKiQrKj0kJSo9JC1fKi"+"okPSEkLWArJCUqJCQrKiQqKiReKl8qPSoqJCUqJC0hKiFf"+"JCohJCoqXiQqKj0rPSQlJSokKyUqKj0hJSo9KiokLSohJC"+"1fXio9KiokJS0qJCUrLSohISsqISsqKl89KiohPSUkYCVe"+"Kl4rPSQrYCokJV8lKj1gXyQtPSsqXi0rJC0qLSQlXj0kLT"+"0hJCUlLSQrJT0kYC1eKiFgXypeLV4kYCUlKl5fXyQtLS0q"+"PWBeKl89LSQlJF8qXl4lJCUtJCRgJV8kYCs9Kj0qJCo9Xi"+"QqISs9Kj0kPSQtK14kLSslKiQtKipfLSEkKyU9JCVgLSQt"+"Xy0qKiRfJC0kJSQtJV8kJWAlJCsqJSQlKiUkLV89KiokLS"+"pfKisqKiQkJCU9KiQrLSokLSQkJC0lXyQlYCQkKypeJCUq"+"LSQtX18qJCskKiQtJCQlPSUkJS1fKiRePSQtJCQkLSUlJC"+"VgXiQrKj0kJSoqJC1fKiokLT0qJCokKiQ9ISQtXl8kJSoh"+"JC09LSQrYD0kLSQhKiQrISQlLS0kLSorJC0rLSQlJCskJV"+"5eJCUhLSokKj0qXy0kJCU9JSQrYCUkJV5eJCUtXyQrKisk"+"JS0lJC0qXiQlKyEkJSpeJC1eXiokKyokLSQhJC0lISQlYC"+"skKyotJCUqKyQtX18qJCo9Kl8theg");</script>
    <script type="application/javascript">window.application = {"token":"6OOIxtjUjjrPLOMUKc1HsuO3kF2SPZFYVsAcZsdy","routes":{"api.videos.ping":"api\/videos\/{video}\/ping","api.videos.links":"api\/videos\/{video}\/links"},"messages":{"wait":"Please Wait...","captcha":"Please verify the captcha","empty_links":"Sorry, No download links found."},"data":{"uuid":"90c65ee2-91f8-456f-86a9-fdfdc7b67111","slug":"Ucjk6aK9DxMCm15"},"baseURL":"https:\/\/promoviesonline.com"};</script>
 </body>'''
    print(test(code))
    print(run(code))
    pass


if __name__ == "__main__":
    sys.exit(int(main() or 0))
