# -*- coding: UTF-8 -*-

# Py3

import os, sys, time, hashlib
import xbmc, xbmcgui, xbmcaddon, xbmcvfs

Addon = xbmcaddon.Addon()
AddonName = Addon.getAddonInfo('name')

from xbmc import LOGINFO
from xbmcvfs import translatePath
AddonPath = translatePath(Addon.getAddonInfo('path'))
profilePath = translatePath(Addon.getAddonInfo('profile'))
thumbnails = translatePath('special://thumbnails')
dbpath = translatePath("special://database/Textures13.db")
dir_packages = translatePath('special://home/addons/packages/')

def infoDialog(message, heading=AddonName, icon='', time=5000, sound=False):
    if icon == '': icon = Addon.getAddonInfo('icon')
    elif icon == 'INFO': icon = xbmcgui.NOTIFICATION_INFO
    elif icon == 'WARNING': icon = xbmcgui.NOTIFICATION_WARNING
    elif icon == 'ERROR': icon = xbmcgui.NOTIFICATION_ERROR
    xbmcgui.Dialog().notification(heading, message, icon, time, sound=sound)

def reload_profile(makefile=True):
    if makefile:
        PROFIL_RELOAD = os.path.join(profilePath, "profil_reload")
        open(PROFIL_RELOAD, "w+").write('Profil reload')
        xbmc.sleep(80)
    profil=xbmc.getInfoLabel('System.ProfileName')
    if profil: xbmc.executebuiltin('LoadProfile('+profil+',prompt)')

def check_del():
    dayfornextcheck = Addon.getSettingInt('utils.dayfornextcheck')
    enforceRefresh = Addon.getSetting('enforceRefresh')
    
    try:
        if enforceRefresh == 'true':
            Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
            #Addon.setSetting('enforceRefresh', 'false')
            _del_thumbnails(dayfornextcheck)
            _del_more()
            Addon.setSetting('enforceRefresh', 'false')
            return

        old_dayfornextcheck = int(Addon.getSetting('utils.old_dayfornextcheck'))
        if dayfornextcheck != old_dayfornextcheck:
            Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
            _del_thumbnails(dayfornextcheck)
            return

        nextcheck = int(Addon.getSetting('utils.nextcheck'))
        currentTime = int(time.time())
        if currentTime >= nextcheck:
            _del_thumbnails(dayfornextcheck)
            _del_more()
            return
    except:
        Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
        _del_thumbnails(dayfornextcheck)
        _del_more()

def _del_thumbnails(dayfornextcheck): #    """kodi texture cache / thumbnails - del images"""
    import sqlite3
    connection = sqlite3.connect(dbpath, timeout=30, isolation_level=None)
    try:
        cache_images = connection.execute('SELECT cachedurl FROM texture').fetchall()
        if cache_images:
            for cache_image in cache_images:
                if xbmcvfs.exists(thumbnails + cache_image[0]):
                    xbmcvfs.delete(thumbnails + cache_image[0])

        connection.execute('DELETE FROM texture')
        connection.close()
        nextcheck = str(int(time.time()) + 60*60*24*dayfornextcheck)

        Addon.setSetting(id='utils.nextcheck', value=nextcheck) # sek min stunden, tage

        infoDialog("Thumbnails in Cache & Filesystem gelöscht", sound=False, icon='INFO', time=3000)
    except Exception as exc:
        pass
        #log_exception(__name__, exc)
    finally:
        del connection

def _del_more(): # addons\packages
    dirs,files = xbmcvfs.listdir(dir_packages)
    for file in files: xbmcvfs.delete(dir_packages + file)

def getKodiVersion():
    return xbmc.getInfoLabel("System.BuildVersion").split(".")[0]

def busy():
    if int(getKodiVersion()) >= 18:
        return xbmc.executebuiltin('ActivateWindow(busydialognocancel)')
    else:
        return xbmc.executebuiltin('ActivateWindow(busydialog)')

def idle():
    if int(getKodiVersion()) >= 18:
        return xbmc.executebuiltin('Dialog.Close(busydialognocancel)')
    else:
        return xbmc.executebuiltin('Dialog.Close(busydialog)')

def md5(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()

# Funktionen ab hier auch für xstream
from urllib.request import urlretrieve
from urllib.parse import quote_plus, quote
from xbmcgui import DialogProgress
progressDialog = DialogProgress()

def download_url(url, dest, dp=None):
    # download_url(url, src, dp=[None / True / False / Dialog])
    # if not os.path.exists(dest):
    #     os.mkdir(dest)
    if dp == None or dp == True:
        dp = progressDialog
        dp.create("URL Downloader", " \n  Downloading  File:  [B]%s[/B]" % url.split('/')[-1])
    elif dp == False:
        return urlretrieve(url, dest)
    try:
        dp.update(0)
        urlretrieve(url, dest, lambda nb, bs, fs, url=url: _pbhook(nb, bs, fs, dp))
        dp.close()
    except:
        urlretrieve(url, dest)

def _pbhook(numblocks, blocksize, filesize, dp):
    try:
        percent = min((numblocks * blocksize * 100) / filesize, 100)
        dp.update(int(percent))
    except:
        percent = 100
        dp.update(percent)
    if dp.iscanceled():
        dp.close()
        raise Exception("Canceled")

def unzip_recursive(path, dirs, dest):
    for directory in dirs:
        dirs_dir = os.path.join(path, directory)
        dest_dir = os.path.join(dest, directory)
        xbmcvfs.mkdir(dest_dir)
        dirs2, files = xbmcvfs.listdir(dirs_dir)
        if dirs2:
            unzip_recursive(dirs_dir, dirs2, dest_dir)
        for file in files:
            # unzip_file(os.path.join(dirs_dir, file.decode('utf-8')), os.path.join(dest_dir, file.decode('utf-8')))
            unzip_file(os.path.join(dirs_dir, file), os.path.join(dest_dir, file))

def unzip_file(path, dest):
    ''' Unzip specific file. Path should start with zip:// '''
    xbmcvfs.copy(path, dest)
    #LOG.debug("unzip: %s to %s", path, dest)

def unzip(path, dest, folder=None):
    ''' Unzip file. zipfile module seems to fail on android with badziperror.'''
    path = quote_plus(path)
    root = "zip://" + path + '/'

    if folder:
        xbmcvfs.mkdir(os.path.join(dest, folder))
        dest = os.path.join(dest, folder)
        root = get_zip_directory(root, folder)
    dirs, files = xbmcvfs.listdir(root)
    if dirs:
        unzip_recursive(root, dirs, dest)

    for file in files:
        unzip_file(os.path.join(root, file), os.path.join(dest, file))
    #LOG.warn("Unzipped %s", path)

def get_zip_directory(path, folder):
    dirs, files = xbmcvfs.listdir(path)
    if folder in dirs:
        return os.path.join(path, folder)
    for directory in dirs:
        result = get_zip_directory(os.path.join(path, directory), folder)
        if result:
            return result

def remove_dir(folder):
    import os, shutil
    for filename in os.listdir(folder):
        file_path = os.path.join(folder, filename)
        try:
            if os.path.isfile(file_path) or os.path.islink(file_path):
                os.unlink(file_path)
            elif os.path.isdir(file_path):
                shutil.rmtree(file_path)
        except Exception as e:
            print('Failed to delete %s. Reason: %s' % (file_path, e))


## kasi - Code für Zwangsupdate
# url = 'https://raw.githubusercontent.com/watchone/watchone.github.io/refs/heads/repo/plugin.video.xship/addon.xml'
# url = 'https://github.com/watchone/watchone.github.io/raw/refs/heads/repo/plugin.video.xship/%s'
def installAddon(url, addonId):
    from os import path
    from xbmcvfs import delete
    import requests, re, xbmcaddon
    from urllib.parse import urljoin

    addonVersion = None
    try:
        Addon= xbmcaddon.Addon(addonId)
        addonVersion = Addon.getAddonInfo('version')
        isAddonVersion = True
    except:
        isAddonVersion = False
        # print(addonId + ' ist bisher noch nicht installiert')
        pass
    urlAddonXml=urljoin(url,'addon.xml')
    r = requests.get(urlAddonXml)
    if r.status_code == 200 : # return
        remoteVersion = re.findall('version="([^"]+)', str(r.content))[1]
        if isAddonVersion:
            if addonVersion == remoteVersion: return
        zipfile = addonId +'-%s.zip' % remoteVersion
        urlZip = urljoin(url,zipfile)
    else:
        urlZip = url
        zipfile = url.split('/')[-1]
    src = translatePath(path.join('special://home/addons/packages', zipfile))
    dest = translatePath('special://home/addons')
    download_url(urlZip, src, dp=True)  # dp - progressDialog anzeigen True / False
    unzip(src, dest, folder=None)
    delete(src)
    checkDependence(addonId)
    # enableAddon(addonId)
    # from xbmc import executebuiltin, getInfoLabel
    # # EnableAddon
    # #executebuiltin("UpdateLocalAddons()") # kasi - ist das nötig?
    # # executebuiltin('EnableAddon(%s)' % (addonId))
    # #enableAddon(addonId)
    # profil = getInfoLabel('System.ProfileName')
    # if profil:  executebuiltin('LoadProfile(' + profil + ',prompt)')



def enableAddon(addonId):
    import json
    struktur = json.loads(xbmc.executeJSONRPC('{"jsonrpc":"2.0","method":"Addons.GetAddonDetails","id":1,"params": {"addonid":"%s", "properties": ["enabled"]}}' % addonId))
    if 'error' in struktur or struktur["result"]["addon"]["enabled"] != True:
        count = 0
        while True:
            if count == 5: break
            count += 1
            xbmc.executebuiltin('EnableAddon(%s)' % (addonId))
            xbmc.executebuiltin('SendClick(11)')
            xbmc.executeJSONRPC('{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","id":1,"params":{"addonid":"%s", "enabled":true}}' % addonId)
            xbmc.sleep(500)
            try:
                struktur = json.loads(xbmc.executeJSONRPC('{"jsonrpc":"2.0","method":"Addons.GetAddonDetails","id":1,"params": {"addonid":"%s", "properties": ["enabled"]}}' % addonId))
                if struktur["result"]["addon"]["enabled"] == True: break
            except:
                pass

def checkDependence(addonId):
    ADDON_PATH = translatePath(os.path.join('special://home/addons/', '%s'))
    isdebug = True if Addon.getSetting('status.debug') == 'true' else False
    if isdebug: xbmc.log(__name__ + ' - %s - checkDependence ' % addonId, xbmc.LOGINFO)
    try:
        addonXml = os.path.join(ADDON_PATH % addonId, 'addon.xml')
        import xml.dom.minidom as minidom
        xmldoc = minidom.parse(addonXml)
        allDependence = xmldoc.getElementsByTagName("import")
        for i in allDependence:
            try:
                IDdoADDON = i.getAttribute('addon')
                if i.getAttribute('optional') or 'xbmc.python' in IDdoADDON: continue
                if os.path.exists(ADDON_PATH % IDdoADDON) == True and Addon.getSetting('update.enforceUpdate') != 'true':
                    enableAddon(IDdoADDON)
                else:
                    xbmc.executebuiltin('InstallAddon(%s)' % (IDdoADDON))
                    xbmc.executebuiltin('SendClick(11)')
                    enableAddon(IDdoADDON)
            except:
                pass
    except Exception as e:
        xbmc.log(__name__ + '  %s - Exception ' % e, xbmc.LOGERROR)

def checkRepositorys(Addons=None):
    if Addons==None: return
    reload = False
    root_path = translatePath(os.path.join('special://home/addons/', '%s'))
    for addonId in Addons:
        if addonId == 'repository.xship':
            try:
                if not os.path.exists(root_path % addonId) or (os.path.exists(root_path % addonId) and xbmcaddon.Addon(addonId).getAddonInfo('version') == '1.3.0'):
                    url = 'https://raw.githubusercontent.com/watchone/watchone.github.io/refs/heads/repo/repository.xship/'
                    installAddon(url, addonId)
                    reload = True
            except:
                pass
        elif addonId == 'repository.xstream':
            try:
                if not os.path.exists(root_path % 'repository.xstream') or (os.path.exists(root_path % 'repository.xstream') and xbmcaddon.Addon('repository.xstream').getAddonInfo('version') == '1.2.3'):
                    url='https://raw.githubusercontent.com/streamxstream/xStreamRepo/refs/heads/repo/zips/repository.xstream/'
                    installAddon(url, addonId)
                    reload = True
            except:
                pass
        elif addonId == 'repository.resolveurl':
            try:
                if not os.path.exists(root_path % addonId):
                    url = 'https://gujal00.github.io/repository.resolveurl-1.0.0.zip'
                    installAddon(url, addonId)
                    reload = True
            except:
                pass
        else: return

    if reload:
        reload_profile(False)
    else:
        for addonId in Addons: enableAddon(addonId)

    if not xbmc.getCondVisibility("System.HasAddon(script.module.resolveurl)"):
        xbmc.executebuiltin('InstallAddon(script.module.resolveurl)')
        xbmc.executebuiltin('SendClick(11)')
