# -*- coding: UTF-8 -*-

# 2022-08-04
# last edit: # 2022-08-28

import os, time
import xbmc, xbmcgui, xbmcaddon
from resources.lib.utils import  profilePath, LOGINFO, busy, idle, check_del, enableAddon, checkRepositorys, installAddon
import script

Addon = xbmcaddon.Addon('service.xS.versioncheck')
AddonID = Addon.getAddonInfo('id')
AddonName = Addon.getAddonInfo('name')

currentTime = int(time.time())

def update():
    from resources.lib.updateManager import Update
    INSTALL_CONTROL = os.path.join(profilePath, "addons_installed")
    try:
        username = Addon.getSetting('service.username')
        plugin_id = AddonID
        branch = 'master'
        token = Addon.getSetting('service.git_token')
        status = Update(username, plugin_id, branch, token, False)   # silent True / False
        if status == True and os.path.isfile(INSTALL_CONTROL)== True:
            os.remove(INSTALL_CONTROL)
        return status
    except Exception as e:
            xbmc.log('Exception Raised: %s' % str(e), LOGINFO)
            pass

if __name__ == '__main__':
    ## install Repos &  "script.module.resolveurl" &
    checkRepositorys({'repository.resolveurl'})

    PROFIL_RELOAD = os.path.join(profilePath, "profil_reload")
    if os.path.isfile(PROFIL_RELOAD) == False:
        if Addon.getSetting('service.check_del') == 'true': check_del()
        if Addon.getSetting('service.git_token') == '' or Addon.getSetting('service.username') == '':
            xbmcgui.Dialog().ok(AddonName, '[COLOR red]' + AddonID + '[/COLOR]\nKeine vollständigen Zugangsdaten! \nAutoUpdate wird deaktiviert!')
            script.setSettingFalse()
        elif Addon.getSetting('service.git_token') != '' and Addon.getSetting('service.username') != '': # and (Addon.getSetting('service.autoupdate') == 'true' or Addon.getSetting('update.enforceUpdate') == 'true') :

            ## kasi - kein Update für das Addon 'service.xS.versioncheck'
            # if AddonID == 'service.xS.versioncheck': exit()

            busy()
            status = ''
            status = update()
            if status == 'auth-error':
                xbmcgui.Dialog().ok(AddonName, 'Fehler beim Update von  [COLOR red]' + AddonID + '[/COLOR]\nUpdate-Key abgelaufen oder Username ungültig!\nAutoUpdate wird deaktiviert!')
                script.setSettingFalse(AddonID)
            elif status == False:
                xbmcgui.Dialog().ok(AddonName, 'Fehler beim Update von [COLOR red]' + AddonID + '[/COLOR]\n ?? Problem Internet ??')

            # elif status == True:
            #     if Addon.getSetting('service.reloadProfil') == 'true':
            #         idle()
            #         xbmc.sleep(200)
            #         reload_profile(False)

            else:
                try: old_nextupdateday = int(Addon.getSetting('service.old_nextupdateday'))
                except: old_nextupdateday = int(Addon.getSetting('service.nextupdateday'))
                if currentTime >= int(Addon.getSetting('service.nextupdate'))or \
                        old_nextupdateday != int(Addon.getSetting('service.nextupdateday')) or \
                        Addon.getSetting('update.enforceUpdate') == 'true':
                    script.main()
                    nextupdate = currentTime + 60*60*24*int(Addon.getSetting('service.nextupdateday'))
                    Addon.setSettingInt('service.nextupdate', nextupdate)
                    Addon.setSetting('service.old_nextupdateday', Addon.getSetting('service.nextupdateday'))
                    if Addon.getSetting('update.enforceUpdate') == 'true': Addon.setSetting('update.enforceUpdate', 'false')

            idle()

    else:
        os.remove(PROFIL_RELOAD)
        if Addon.getSetting('update.enforceUpdate') == 'true': Addon.setSetting('update.enforceUpdate', 'false')
        #utils.infoDialog("Auto Update abgeschlossen", sound=False, icon='INFO', time=3000)
        _Addons, ADDONIDS = script.getSettings()
        for ADDONID in ADDONIDS: enableAddon(ADDONID)


